/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query.experimental.filters;

import com.mongodb.client.model.geojson.Point;
import com.mongodb.lang.NonNull;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.experimental.filters.Filter;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

class CenterFilter
extends Filter {
    private final double radius;

    protected CenterFilter(String filterName, String field, Point value, double radius) {
        super(filterName, field, value);
        this.radius = radius;
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext context) {
        writer.writeStartDocument(this.path(mapper));
        writer.writeStartDocument("$geoWithin");
        writer.writeStartArray(this.getName());
        Point center = this.getValue();
        writer.writeStartArray();
        for (Double value : center.getPosition().getValues()) {
            writer.writeDouble(value);
        }
        writer.writeEndArray();
        writer.writeDouble(this.radius);
        writer.writeEndArray();
        writer.writeEndDocument();
        writer.writeEndDocument();
    }

    @Override
    @NonNull
    public Point getValue() {
        Object value = super.getValue();
        if (value != null) {
            return (Point)value;
        }
        throw new NullPointerException();
    }
}

