/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.client.MongoCollection;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.internal.PathTarget;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.Operations;
import dev.morphia.query.Query;
import dev.morphia.query.experimental.updates.UpdateOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;

public abstract class UpdateBase<T> {
    private final Query<T> query;
    private final MongoCollection<T> collection;
    private final Mapper mapper;
    private final Class<T> type;
    private final List<UpdateOperator> updates = new ArrayList<UpdateOperator>();
    private final Datastore datastore;

    UpdateBase(Datastore datastore, Mapper mapper, @Nullable MongoCollection<T> collection, @Nullable Query<T> query, Class<T> type2) {
        this.datastore = datastore;
        this.mapper = mapper;
        this.collection = collection;
        this.query = query;
        this.type = type2;
    }

    UpdateBase(Datastore datastore, Mapper mapper, MongoCollection<T> collection, Query<T> query, Class<T> type2, UpdateOperator first, UpdateOperator[] updates) {
        this.datastore = datastore;
        this.mapper = mapper;
        this.type = type2;
        this.updates.add(first);
        this.updates.addAll(Arrays.asList(updates));
        this.query = query;
        this.collection = collection;
    }

    UpdateBase(Datastore datastore, Mapper mapper, MongoCollection<T> collection, Query<T> query, Class<T> type2, List<UpdateOperator> updates) {
        this(datastore, mapper, collection, query, type2);
        this.updates.addAll(updates);
    }

    public void add(UpdateOperator operator) {
        this.updates.add(operator);
    }

    public Document toDocument() {
        Operations operations = new Operations(this.mapper, this.mapper.getEntityModel(this.type));
        for (UpdateOperator update : this.updates) {
            PathTarget pathTarget = new PathTarget(this.mapper, this.mapper.getEntityModel(this.type), update.field(), true);
            operations.add(update.operator(), update.toTarget(pathTarget));
        }
        return operations.toDocument();
    }

    public String toString() {
        return this.toDocument().toString();
    }

    protected MongoCollection<T> getCollection() {
        return this.collection;
    }

    protected Datastore getDatastore() {
        return this.datastore;
    }

    protected Query<T> getQuery() {
        return this.query;
    }

    protected List<UpdateOperator> getUpdates() {
        return this.updates;
    }
}

