/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.DatastoreImpl;
import dev.morphia.DeleteOptions;
import dev.morphia.annotations.Entity;
import dev.morphia.internal.MorphiaInternals;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.query.CountOptions;
import dev.morphia.query.Criteria;
import dev.morphia.query.CriteriaContainer;
import dev.morphia.query.CriteriaContainerImpl;
import dev.morphia.query.CriteriaJoin;
import dev.morphia.query.FieldCriteria;
import dev.morphia.query.FieldEnd;
import dev.morphia.query.FieldEndImpl;
import dev.morphia.query.FilterOperator;
import dev.morphia.query.FindAndDeleteOptions;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Modify;
import dev.morphia.query.Projection;
import dev.morphia.query.Query;
import dev.morphia.query.Update;
import dev.morphia.query.UpdateOperations;
import dev.morphia.query.UpdateOpsImpl;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.query.internal.MorphiaCursor;
import dev.morphia.query.internal.MorphiaKeyCursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.Document;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyQuery<T>
implements CriteriaContainer,
Query<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyQuery.class);
    private final DatastoreImpl datastore;
    private final Class<T> clazz;
    private final Mapper mapper;
    private final String collectionName;
    private final MongoCollection<T> collection;
    private final EntityModel model;
    private final CriteriaContainer compoundContainer;
    private boolean validateName = true;
    private boolean validateType = true;
    private Document baseQuery;
    @Deprecated
    private FindOptions options;

    protected LegacyQuery(Datastore datastore, @Nullable String collectionName, Class<T> clazz) {
        this.clazz = clazz;
        this.datastore = (DatastoreImpl)datastore;
        this.mapper = this.datastore.getMapper();
        this.model = this.mapper.getEntityModel(clazz);
        if (collectionName != null) {
            this.collection = datastore.getDatabase().getCollection(collectionName, clazz);
            this.collectionName = collectionName;
        } else {
            this.collection = this.mapper.getCollection(clazz);
            this.collectionName = this.collection.getNamespace().getCollectionName();
        }
        this.compoundContainer = new CriteriaContainerImpl(this.mapper, this, CriteriaJoin.AND);
    }

    @Override
    public void add(Criteria ... criteria) {
        for (Criteria c : criteria) {
            c.attach(this);
            this.compoundContainer.add(c);
        }
    }

    @Override
    public CriteriaContainer and(Criteria ... criteria) {
        return this.compoundContainer.and(criteria);
    }

    @Override
    public FieldEnd<? extends CriteriaContainer> criteria(String field) {
        CriteriaContainerImpl container = new CriteriaContainerImpl(this.mapper, this, CriteriaJoin.AND);
        this.add(container);
        return new FieldEndImpl<CriteriaContainerImpl>(this.mapper, field, container, this.model, this.isValidatingNames());
    }

    @Override
    public CriteriaContainer or(Criteria ... criteria) {
        return this.compoundContainer.or(criteria);
    }

    @Override
    public void remove(Criteria criteria) {
        this.compoundContainer.remove(criteria);
    }

    @Override
    public void attach(CriteriaContainer container) {
        this.compoundContainer.attach(container);
    }

    @Override
    public String getFieldName() {
        throw new UnsupportedOperationException("this method is unused on a Query");
    }

    @Override
    @Deprecated(since="2.0", forRemoval=true)
    public MorphiaCursor<T> execute() {
        return this.iterator();
    }

    @Override
    public long count() {
        return this.count(new CountOptions());
    }

    @Override
    public long count(CountOptions options) {
        ClientSession session = this.datastore.findSession(options);
        return session == null ? this.getCollection().countDocuments(this.getQueryDocument(), options) : this.getCollection().countDocuments(session, this.getQueryDocument(), options);
    }

    @Override
    public T findAndDelete(FindAndDeleteOptions options) {
        MongoCollection<T> mongoCollection = options.prepare(this.getCollection());
        ClientSession session = this.datastore.findSession(options);
        return session == null ? mongoCollection.findOneAndDelete(this.getQueryDocument(), options) : mongoCollection.findOneAndDelete(session, this.getQueryDocument(), options);
    }

    @Override
    public DeleteResult delete(DeleteOptions options) {
        MongoCollection<T> collection = options.prepare(this.getCollection());
        ClientSession session = this.datastore.findSession(options);
        if (options.isMulti()) {
            return session == null ? collection.deleteMany(this.getQueryDocument(), options) : collection.deleteMany(session, this.getQueryDocument(), options);
        }
        return session == null ? collection.deleteOne(this.getQueryDocument(), options) : collection.deleteOne(session, this.getQueryDocument(), options);
    }

    @Override
    public Query<T> disableValidation() {
        this.validateName = false;
        this.validateType = false;
        return this;
    }

    @Override
    public Query<T> enableValidation() {
        this.validateName = true;
        this.validateType = true;
        return this;
    }

    @Override
    @Deprecated(since="2.0", forRemoval=true)
    public MorphiaCursor<T> execute(FindOptions options) {
        return this.iterator(options);
    }

    @Override
    public Map<String, Object> explain(FindOptions options, @Nullable ExplainVerbosity verbosity) {
        return (Map)((Object)MorphiaInternals.tryInvoke(MorphiaInternals.DriverVersion.v4_2_0, () -> verbosity == null ? this.iterable(options, this.collection).explain() : this.iterable(options, this.collection).explain(verbosity), () -> new LinkedHashMap<String, Object>(this.datastore.getDatabase().runCommand(new Document("explain", new Document("find", this.getCollection().getNamespace().getCollectionName()).append("filter", this.getQueryDocument()))))));
    }

    @Override
    public FieldEnd<? extends Query<T>> field(String name) {
        return new FieldEndImpl<LegacyQuery>(this.mapper, name, this, this.model, this.isValidatingNames());
    }

    @Override
    public Query<T> filter(String condition, Object value) {
        String[] parts = condition.trim().split(" ");
        if (parts.length < 1 || parts.length > 6) {
            throw new IllegalArgumentException("'" + condition + "' is not a legal filter condition");
        }
        String prop = parts[0].trim();
        FilterOperator op = parts.length == 2 ? this.translate(parts[1]) : FilterOperator.EQUAL;
        this.add(new FieldCriteria(this.mapper, prop, op, value, this.mapper.getEntityModel(this.getEntityClass()), this.isValidatingNames()));
        return this;
    }

    @Override
    public Modify<T> modify(UpdateOperator first, UpdateOperator ... updates) {
        return new Modify<T>(this.datastore, this.mapper, this.getCollection(), this, this.clazz, first, updates);
    }

    @Override
    public T first() {
        return this.first(new FindOptions());
    }

    @Override
    public T first(FindOptions options) {
        try (MorphiaCursor<T> it = this.iterator(options.copy().limit(1));){
            Object TResult = it.tryNext();
            return (T)TResult;
        }
    }

    @Override
    public Class<T> getEntityClass() {
        return this.clazz;
    }

    @Override
    public Update<T> update(UpdateOperator first, UpdateOperator ... updates) {
        return new Update<T>(this.datastore, this.mapper, this.getCollection(), this, this.clazz, first, updates);
    }

    @Override
    public MorphiaCursor<T> iterator(FindOptions options) {
        return new MorphiaCursor<T>(this.prepareCursor(options, this.getCollection()));
    }

    @Override
    public MorphiaKeyCursor<T> keys() {
        return this.keys(new FindOptions());
    }

    @Override
    public MorphiaKeyCursor<T> keys(FindOptions options) {
        FindOptions returnKey = new FindOptions().copy(options).projection().include("_id");
        return new MorphiaKeyCursor<T>(this.prepareCursor(returnKey, this.datastore.getDatabase().getCollection(this.getCollectionName())), this.datastore.getMapper(), this.clazz, this.getCollectionName());
    }

    @Override
    public Modify<T> modify(UpdateOperations<T> operations) {
        return new Modify<T>((Datastore)this.datastore, this.mapper, this.getCollection(), this, this.clazz, (UpdateOpsImpl)operations);
    }

    @Override
    public Query<T> retrieveKnownFields() {
        this.getOptions().projection().knownFields();
        return this;
    }

    @Override
    public Query<T> search(String search) {
        this.criteria("$text").equal(new Document("$search", search));
        return this;
    }

    @Override
    public Query<T> search(String search, String language) {
        this.criteria("$text").equal(new Document("$search", search).append("$language", language));
        return this;
    }

    public MongoCollection<T> getCollection() {
        return this.collection;
    }

    @Override
    @Deprecated(since="2.0", forRemoval=true)
    public Update<T> update(UpdateOperations<T> operations) {
        return new Update<T>((Datastore)this.datastore, this.mapper, this.getCollection(), this, this.clazz, (UpdateOpsImpl)operations);
    }

    @Override
    public Document toDocument() {
        Document query = this.getQueryDocument();
        EntityModel model = this.mapper.getEntityModel(this.getEntityClass());
        Entity entityAnnotation = model.getEntityAnnotation();
        if (entityAnnotation != null && entityAnnotation.useDiscriminator() && !query.containsKey("_id") && !query.containsKey(model.getDiscriminatorKey())) {
            List<EntityModel> subtypes = this.mapper.getEntityModel(this.getEntityClass()).getSubtypes();
            ArrayList<String> values2 = new ArrayList<String>();
            values2.add(model.getDiscriminator());
            for (EntityModel subtype : subtypes) {
                values2.add(subtype.getDiscriminator());
            }
            query.put(model.getDiscriminatorKey(), (Object)new Document("$in", values2));
        }
        return query;
    }

    @Nullable
    public Document getFieldsObject() {
        Projection projection = this.getOptions().getProjection();
        return projection != null ? projection.map(this.mapper, this.clazz) : null;
    }

    @Nullable
    public Document getSort() {
        return this.options != null ? this.options.getSort() : null;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.validateName, this.validateType, this.baseQuery, this.getOptions(), this.compoundContainer, this.getCollectionName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LegacyQuery)) {
            return false;
        }
        LegacyQuery query = (LegacyQuery)o;
        return this.validateName == query.validateName && this.validateType == query.validateType && Objects.equals(this.clazz, query.clazz) && Objects.equals(this.baseQuery, query.baseQuery) && Objects.equals(this.getOptions(), query.getOptions()) && Objects.equals(this.compoundContainer, query.compoundContainer) && Objects.equals(this.getCollectionName(), query.getCollectionName());
    }

    public String toString() {
        return this.getOptions().getProjection() == null ? this.getQueryDocument().toString() : String.format("{ %s, %s }", this.getQueryDocument(), this.getFieldsObject());
    }

    public boolean isValidatingNames() {
        return this.validateName;
    }

    public void setQueryObject(Document query) {
        this.baseQuery = new Document(query);
    }

    protected Datastore getDatastore() {
        return this.datastore;
    }

    private String getCollectionName() {
        return this.collectionName;
    }

    private Document getQueryDocument() {
        Document obj = new Document();
        if (this.baseQuery != null) {
            obj.putAll(this.baseQuery);
        }
        obj.putAll(this.compoundContainer.toDocument());
        this.mapper.updateQueryWithDiscriminators(this.mapper.getEntityModel(this.getEntityClass()), obj);
        return obj;
    }

    @NotNull
    private <E> FindIterable<E> iterable(FindOptions options, MongoCollection<E> collection) {
        ClientSession clientSession;
        Document query = this.toDocument();
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("Running query(%s) : %s, options: %s,", this.getCollectionName(), query.toJson(), options));
        }
        if (options.getCursorType() != null && options.getCursorType() != CursorType.NonTailable && options.getSort() != null) {
            LOG.warn("Sorting on tail is not allowed.");
        }
        FindIterable<E> iterable = (clientSession = this.datastore.findSession(options)) != null ? collection.find(clientSession, query) : collection.find(query);
        return iterable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> MongoCursor<E> prepareCursor(FindOptions options, MongoCollection<E> collection) {
        Document oldProfile = null;
        if (options.isLogQuery()) {
            oldProfile = this.datastore.getDatabase().runCommand(new Document("profile", 2).append("slowms", 0));
        }
        try {
            Iterator iterator2 = options.apply(this.iterable(options, collection), this.mapper, this.clazz).iterator();
            return iterator2;
        }
        finally {
            if (options.isLogQuery()) {
                this.datastore.getDatabase().runCommand(new Document("profile", oldProfile.get("was")).append("slowms", oldProfile.get("slowms")).append("sampleRate", oldProfile.get("sampleRate")));
            }
        }
    }

    private FilterOperator translate(String operator) {
        return FilterOperator.fromString(operator);
    }

    FindOptions getOptions() {
        if (this.options == null) {
            this.options = new FindOptions();
        }
        return this.options;
    }
}

