/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.query;

import com.mongodb.CursorType;
import com.mongodb.DBObject;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.lang.Nullable;
import dev.morphia.internal.MorphiaInternals;
import dev.morphia.internal.PathTarget;
import dev.morphia.internal.ReadConfigurable;
import dev.morphia.internal.SessionConfigurable;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.query.Meta;
import dev.morphia.query.Projection;
import dev.morphia.query.Sort;
import dev.morphia.sofia.Sofia;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.types.ObjectId;

public final class FindOptions
implements SessionConfigurable<FindOptions>,
ReadConfigurable<FindOptions> {
    private Boolean allowDiskUse;
    private int batchSize;
    private int limit;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private int skip;
    private Document sort;
    private CursorType cursorType;
    private boolean noCursorTimeout;
    private boolean oplogReplay;
    private boolean partial;
    private Collation collation;
    private String comment;
    private Document hint;
    private String hintString;
    private Document max;
    private Document min;
    private boolean returnKey;
    private boolean showRecordId;
    private ReadConcern readConcern;
    private ReadPreference readPreference;
    private Projection projection;
    private String queryLogId;
    private ClientSession clientSession;

    public FindOptions allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    public <T> FindIterable<T> apply(FindIterable<T> iterable, Mapper mapper, Class<?> type2) {
        if (this.projection != null) {
            iterable.projection(this.projection.map(mapper, type2));
        }
        MorphiaInternals.tryInvoke(MorphiaInternals.DriverVersion.v4_1_0, () -> iterable.allowDiskUse(this.allowDiskUse));
        iterable.batchSize(this.batchSize);
        iterable.collation(this.collation);
        iterable.comment(this.comment);
        if (this.cursorType != null) {
            iterable.cursorType(this.cursorType);
        }
        iterable.hint(this.hint);
        iterable.hintString(this.hintString);
        iterable.limit(this.limit);
        iterable.max(this.max);
        iterable.maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
        iterable.maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        iterable.min(this.min);
        iterable.noCursorTimeout(this.noCursorTimeout);
        iterable.oplogReplay(this.oplogReplay);
        iterable.partial(this.partial);
        iterable.returnKey(this.returnKey);
        iterable.showRecordId(this.showRecordId);
        iterable.skip(this.skip);
        if (this.sort != null) {
            Document mapped = new Document();
            EntityModel model = mapper.getEntityModel(type2);
            for (Map.Entry<String, Object> entry : this.sort.entrySet()) {
                Object value = entry.getValue();
                boolean metaScore = value instanceof Document && ((Document)value).get("$meta") != null;
                mapped.put(new PathTarget(mapper, model, entry.getKey(), !metaScore).translatedPath(), value);
            }
            iterable.sort(mapped);
        }
        return iterable;
    }

    public FindOptions batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public FindOptions clientSession(ClientSession clientSession) {
        this.clientSession = clientSession;
        return this;
    }

    @Override
    public ClientSession clientSession() {
        return this.clientSession;
    }

    public FindOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public FindOptions comment(String comment) {
        this.comment = comment;
        return this;
    }

    public FindOptions copy() {
        return new FindOptions().copy(this);
    }

    public FindOptions copy(FindOptions original) {
        this.allowDiskUse = original.allowDiskUse;
        this.batchSize = original.batchSize;
        this.limit = original.limit;
        this.maxTimeMS = original.maxTimeMS;
        this.maxAwaitTimeMS = original.maxAwaitTimeMS;
        this.skip = original.skip;
        this.sort = original.sort;
        this.cursorType = original.cursorType;
        this.noCursorTimeout = original.noCursorTimeout;
        this.oplogReplay = original.oplogReplay;
        this.partial = original.partial;
        this.collation = original.collation;
        this.comment = original.comment;
        this.hint = original.hint;
        this.hintString = original.hintString;
        this.max = original.max;
        this.min = original.min;
        this.returnKey = original.returnKey;
        this.showRecordId = original.showRecordId;
        this.readConcern = original.readConcern;
        this.readPreference = original.readPreference;
        this.projection = original.projection;
        this.queryLogId = original.queryLogId;
        this.clientSession = original.clientSession;
        return this;
    }

    public FindOptions cursorType(CursorType cursorType) {
        this.cursorType = Assertions.notNull("cursorType", cursorType);
        return this;
    }

    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public CursorType getCursorType() {
        return this.cursorType;
    }

    @Nullable
    public Document getHint() {
        return this.hint;
    }

    public int getLimit() {
        return this.limit;
    }

    @Nullable
    public Document getMax() {
        return this.max;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public Document getMin() {
        return this.min;
    }

    @Nullable
    public Projection getProjection() {
        return this.projection;
    }

    public String getQueryLogId() {
        return this.queryLogId;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public FindOptions readConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    @Override
    public FindOptions readPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    @Nullable
    public Document getSort() {
        return this.sort;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowDiskUse, this.batchSize, this.limit, this.maxTimeMS, this.maxAwaitTimeMS, this.skip, this.sort, this.cursorType, this.noCursorTimeout, this.oplogReplay, this.partial, this.collation, this.comment, this.hint, this.hintString, this.max, this.min, this.returnKey, this.showRecordId, this.readConcern, this.readPreference, this.projection, this.queryLogId, this.clientSession});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FindOptions)) {
            return false;
        }
        FindOptions that = (FindOptions)o;
        return this.batchSize == that.batchSize && this.limit == that.limit && this.maxTimeMS == that.maxTimeMS && this.maxAwaitTimeMS == that.maxAwaitTimeMS && this.skip == that.skip && this.noCursorTimeout == that.noCursorTimeout && this.oplogReplay == that.oplogReplay && this.partial == that.partial && this.returnKey == that.returnKey && this.showRecordId == that.showRecordId && Objects.equals(this.allowDiskUse, that.allowDiskUse) && Objects.equals(this.sort, that.sort) && this.cursorType == that.cursorType && Objects.equals(this.collation, that.collation) && Objects.equals(this.comment, that.comment) && Objects.equals(this.hint, that.hint) && Objects.equals(this.hintString, that.hintString) && Objects.equals(this.max, that.max) && Objects.equals(this.min, that.min) && Objects.equals(this.readConcern, that.readConcern) && Objects.equals(this.readPreference, that.readPreference) && Objects.equals(this.projection, that.projection) && Objects.equals(this.queryLogId, that.queryLogId) && Objects.equals(this.clientSession, that.clientSession);
    }

    public String toString() {
        return new StringJoiner(", ", FindOptions.class.getSimpleName() + "[", "]").add("allowDiskUse=" + this.allowDiskUse).add("batchSize=" + this.batchSize).add("limit=" + this.limit).add("maxTimeMS=" + this.maxTimeMS).add("maxAwaitTimeMS=" + this.maxAwaitTimeMS).add("skip=" + this.skip).add("sort=" + this.sort).add("cursorType=" + this.cursorType).add("noCursorTimeout=" + this.noCursorTimeout).add("oplogReplay=" + this.oplogReplay).add("partial=" + this.partial).add("collation=" + this.collation).add("comment='" + this.comment + "'").add("hint=" + this.hint).add("max=" + this.max).add("min=" + this.min).add("returnKey=" + this.returnKey).add("showRecordId=" + this.showRecordId).add("readPreference=" + this.readPreference).add("queryLogId='" + this.queryLogId + "'").add("projection=" + this.projection).toString();
    }

    public FindOptions hint(Document hint) {
        this.hint = hint;
        return this;
    }

    public FindOptions hint(String hint) {
        this.hintString(hint);
        return this;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public FindOptions hint(DBObject hint) {
        return this.hint(new Document(hint.toMap()));
    }

    public FindOptions hintString(String hint) {
        this.hintString = hint;
        return this;
    }

    public boolean isLogQuery() {
        return this.queryLogId != null;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public boolean isOplogReplay() {
        return this.oplogReplay;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public boolean isReturnKey() {
        return this.returnKey;
    }

    public boolean isShowRecordId() {
        return this.showRecordId;
    }

    public FindOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public FindOptions logQuery() {
        this.queryLogId = new ObjectId().toString();
        this.comment(Sofia.loggedQuery(this.queryLogId, new Locale[0]));
        return this;
    }

    public FindOptions max(Document max2) {
        this.max = max2;
        return this;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public FindOptions max(DBObject max2) {
        return this.hint(new Document(max2.toMap()));
    }

    public FindOptions maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime > = 0", maxAwaitTime >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public FindOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime > = 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public FindOptions min(Document min2) {
        this.min = min2;
        return this;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public FindOptions min(DBObject min2) {
        return this.hint(new Document(min2.toMap()));
    }

    public FindOptions noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public FindOptions oplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
        return this;
    }

    public FindOptions partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public Projection projection() {
        if (this.projection == null) {
            this.projection = new Projection(this);
        }
        return this.projection;
    }

    public FindOptions returnKey(boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public FindOptions showRecordId(boolean showRecordId) {
        this.showRecordId = showRecordId;
        return this;
    }

    public FindOptions skip(int skip) {
        this.skip = skip;
        return this;
    }

    public FindOptions sort(Meta meta) {
        this.projection().project(meta);
        return this.sort(meta.toDatabase());
    }

    public FindOptions sort(Document sort2) {
        this.sort = sort2;
        return this;
    }

    public FindOptions sort(Sort ... sorts) {
        this.sort = new Document();
        for (Sort sort2 : sorts) {
            this.sort.append(sort2.getField(), sort2.getOrder());
        }
        return this;
    }
}

