/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.experimental;

import com.mongodb.DBRef;
import dev.morphia.Datastore;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.references.ReferenceCodec;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.mapping.lazy.proxy.ReferenceException;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.sofia.Sofia;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class CollectionReference<C extends Collection>
extends MorphiaReference<C> {
    private EntityModel entityModel;
    private List ids;
    private final Map<String, List<Object>> collections = new HashMap<String, List<Object>>();

    CollectionReference(Datastore datastore, EntityModel entityModel, List ids) {
        super(datastore);
        this.entityModel = entityModel;
        if (ids != null) {
            if (ids.stream().allMatch(entityModel.getType()::isInstance)) {
                this.setValues(ids);
            } else {
                for (Object o : ids) {
                    CollectionReference.collate(entityModel, this.collections, o);
                }
                this.ids = ids;
            }
        }
    }

    abstract void setValues(List var1);

    protected CollectionReference() {
    }

    static void collate(EntityModel valueType, Map<String, List<Object>> collections, Object o) {
        Object id;
        String collectionName;
        if (o instanceof DBRef) {
            DBRef dbRef = (DBRef)o;
            collectionName = dbRef.getCollectionName();
            id = dbRef.getId();
        } else {
            collectionName = valueType.getCollectionName();
            id = o;
        }
        CollectionReference.register(collections, collectionName).add(id);
    }

    static List register(Map<String, List<Object>> collections, String name) {
        return collections.computeIfAbsent(name, k -> new ArrayList());
    }

    @Override
    public abstract C get();

    @Override
    public Class<C> getType() {
        return this.entityModel.getType();
    }

    @Override
    public List<Object> getIds() {
        ArrayList<Object> ids = new ArrayList<Object>(this.ids);
        if (!ids.isEmpty() && ids.get(0) instanceof DBRef) {
            ListIterator<Object> iterator2 = ids.listIterator();
            while (iterator2.hasNext()) {
                iterator2.set(((DBRef)iterator2.next()).getId());
            }
        }
        return ids;
    }

    @Override
    final List<Object> getId(Mapper mapper, Datastore datastore, EntityModel entityModel) {
        if (this.ids == null) {
            this.ids = this.getValues().stream().map(v -> ReferenceCodec.encodeId(mapper, v, entityModel)).collect(Collectors.toList());
        }
        return this.ids;
    }

    private List<Object> extractIds(List<Object> list) {
        ArrayList<Object> ids = new ArrayList<Object>();
        list.forEach(i2 -> {
            if (i2 instanceof List) {
                ids.addAll(this.extractIds((List)i2));
            } else {
                ids.add(i2);
            }
        });
        return ids;
    }

    private List<Object> mapIds(List list, Map<Object, Object> idMap) {
        ArrayList<Object> values2 = new ArrayList<Object>(Arrays.asList(new Object[list.size()]));
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object id = list.get(i2);
            Object value = id instanceof List ? this.mapIds((List)id, idMap) : idMap.get(id instanceof DBRef ? ((DBRef)id).getId() : id);
            if (value == null) continue;
            values2.set(i2, value);
        }
        return values2;
    }

    final List find() {
        HashMap<Object, Object> idMap = new HashMap<Object, Object>();
        for (Map.Entry<String, List<Object>> entry : this.collections.entrySet()) {
            idMap.putAll(this.query(entry.getKey(), this.extractIds(entry.getValue())));
        }
        List values2 = this.mapIds(this.ids, idMap).stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.resolve();
        return values2;
    }

    abstract Collection<?> getValues();

    Map<Object, Object> query(String collection, List<Object> collectionIds) {
        HashMap<Object, Object> idMap = new HashMap<Object, Object>();
        try (Iterator cursor = this.getDatastore().find(collection).disableValidation().filter(Filters.in("_id", collectionIds)).iterator();){
            while (cursor.hasNext()) {
                Object entity = cursor.next();
                idMap.put(this.getDatastore().getMapper().getId(entity), entity);
            }
            if (!this.ignoreMissing() && idMap.size() != collectionIds.size()) {
                throw new ReferenceException(Sofia.missingReferencedEntities(this.entityModel.getType().getSimpleName(), new Locale[0]));
            }
        }
        return idMap;
    }
}

