/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.conventions;

import dev.morphia.Datastore;
import dev.morphia.annotations.AlsoLoad;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Property;
import dev.morphia.annotations.Version;
import dev.morphia.annotations.experimental.IdField;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.codec.MorphiaPropertySerialization;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.codec.pojo.PropertyModelBuilder;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.conventions.MorphiaConvention;
import java.beans.Transient;
import java.lang.reflect.Modifier;
import java.util.Iterator;

public class ConfigureProperties
implements MorphiaConvention {
    private static boolean isTransient(PropertyModelBuilder property) {
        return property.hasAnnotation(dev.morphia.annotations.Transient.class) || property.hasAnnotation(Transient.class) || Modifier.isTransient(property.modifiers());
    }

    @Override
    public void apply(Datastore datastore, EntityModelBuilder modelBuilder) {
        IdField idProperty;
        MapperOptions options = datastore.getMapper().getOptions();
        this.processProperties(modelBuilder, options);
        if (modelBuilder.idPropertyName() == null && (idProperty = modelBuilder.getAnnotation(IdField.class)) != null) {
            modelBuilder.idPropertyName(idProperty.value());
            PropertyModelBuilder propertyModelBuilder = modelBuilder.propertyModelByName(idProperty.value());
            propertyModelBuilder.mappedName("_id");
        }
    }

    private void buildProperty(MapperOptions options, PropertyModelBuilder builder) {
        builder.serialization(new MorphiaPropertySerialization(options, builder));
        if (this.isNotConcrete(builder.typeData())) {
            builder.discriminatorEnabled(true);
        }
    }

    void processProperties(EntityModelBuilder modelBuilder, MapperOptions options) {
        Iterator<PropertyModelBuilder> iterator2 = modelBuilder.propertyModels().iterator();
        while (iterator2.hasNext()) {
            AlsoLoad alsoLoad;
            PropertyModelBuilder builder = iterator2.next();
            int modifiers = builder.modifiers();
            if (Modifier.isStatic(modifiers) || ConfigureProperties.isTransient(builder)) {
                iterator2.remove();
                continue;
            }
            Property property = builder.getAnnotation(Property.class);
            if (property != null && !property.concreteClass().equals(Object.class)) {
                TypeData<?> typeData = builder.typeData().withType(property.concreteClass());
                builder.typeData(typeData);
            }
            if ((alsoLoad = builder.getAnnotation(AlsoLoad.class)) != null) {
                for (String name : alsoLoad.value()) {
                    builder.alternateName(name);
                }
            }
            if (builder.getAnnotation(Id.class) != null) {
                modelBuilder.idPropertyName(builder.name());
            }
            if (builder.getAnnotation(Version.class) != null) {
                modelBuilder.versionPropertyName(builder.name());
            }
            this.buildProperty(options, builder);
        }
    }

    private boolean isNotConcrete(TypeData<?> typeData) {
        Class<?> type2 = !typeData.getTypeParameters().isEmpty() ? typeData.getTypeParameters().get(typeData.getTypeParameters().size() - 1).getType() : typeData.getType();
        return this.isNotConcrete(type2);
    }

    private boolean isNotConcrete(Class<?> type2) {
        Class<?> componentType = type2;
        if (type2.isArray()) {
            componentType = type2.getComponentType();
        }
        return componentType.isInterface() || Modifier.isAbstract(componentType.getModifiers());
    }

    String applyDefaults(String configured, String defaultValue) {
        if (!configured.equals(".")) {
            return configured;
        }
        return defaultValue;
    }
}

