/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.writer;

import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.codec.writer.NameState;
import dev.morphia.mapping.codec.writer.RootState;
import dev.morphia.mapping.codec.writer.WriteState;
import dev.morphia.sofia.Sofia;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Locale;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class DocumentWriter
implements BsonWriter {
    private final RootState root;
    private WriteState state;
    private int arraysLevel;
    private int docsLevel;
    private final Mapper mapper;

    public DocumentWriter(Mapper mapper) {
        this.mapper = mapper;
        this.root = new RootState(this);
        this.state = this.root;
    }

    public DocumentWriter(Mapper mapper, Document seed) {
        this.root = new RootState(this, seed);
        this.mapper = mapper;
        this.state = this.root;
    }

    public DocumentWriter encode(CodecRegistry codecRegistry, Object value, EncoderContext encoderContext) {
        codecRegistry.get(value.getClass()).encode(this, value, encoderContext);
        return this;
    }

    @Override
    public void flush() {
    }

    public int getArraysLevel() {
        return this.arraysLevel;
    }

    public int getDocsLevel() {
        return this.docsLevel;
    }

    public Document getDocument() {
        if (this.arraysLevel != 0 || this.docsLevel != 0) {
            throw new IllegalStateException(Sofia.unbalancedOpens(this.arraysLevel, this.docsLevel, this.state, new Locale[0]));
        }
        return this.root.getDocument();
    }

    public void previous() {
        this.state((WriteState)this.state.previous());
        if (this.state() instanceof NameState) {
            this.previous();
        }
    }

    public WriteState state() {
        return this.state;
    }

    @Override
    public void writeBinaryData(BsonBinary binary) {
        this.state.value(binary);
    }

    @Override
    public void writeBinaryData(String name, BsonBinary binary) {
        this.state.name(name).value(binary);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.state.value(value);
    }

    @Override
    public void writeBoolean(String name, boolean value) {
        this.state.name(name).value(value);
    }

    @Override
    public void writeDateTime(long value) {
        this.state.value(LocalDateTime.ofInstant(Instant.ofEpochMilli(value), this.mapper.getOptions().getDateStorage().getZone()));
    }

    @Override
    public void writeDateTime(String name, long value) {
        this.state.name(name);
        this.writeDateTime(value);
    }

    @Override
    public void writeDBPointer(BsonDbPointer value) {
        this.state.value(value);
    }

    @Override
    public void writeDBPointer(String name, BsonDbPointer value) {
        this.state.name(name).value(value);
    }

    @Override
    public void writeDouble(double value) {
        this.state.value(value);
    }

    @Override
    public void writeDouble(String name, double value) {
        this.state.name(name).value(value);
    }

    @Override
    public void writeEndArray() {
        --this.arraysLevel;
        this.state.end();
    }

    @Override
    public void writeEndDocument() {
        --this.docsLevel;
        this.state.end();
    }

    @Override
    public void writeInt32(int value) {
        this.state.value(value);
    }

    @Override
    public void writeInt32(String name, int value) {
        this.state.name(name).value(value);
    }

    @Override
    public void writeInt64(long value) {
        this.state.value(value);
    }

    @Override
    public void writeInt64(String name, long value) {
        this.state.name(name).value(value);
    }

    @Override
    public void writeDecimal128(Decimal128 value) {
        this.state.value(value);
    }

    @Override
    public void writeDecimal128(String name, Decimal128 value) {
        this.state.name(name).value(value);
    }

    @Override
    public void writeJavaScript(String code) {
        this.state.value(code);
    }

    @Override
    public void writeMaxKey(String name) {
        this.writeName(name);
        this.writeMaxKey();
    }

    @Override
    public void writeJavaScript(String name, String code) {
        this.state.name(name).value(code);
    }

    @Override
    public void writeMinKey(String name) {
        this.writeName(name);
        this.writeMinKey();
    }

    @Override
    public void writeJavaScriptWithScope(String code) {
        this.state.value(code);
    }

    @Override
    public void writeJavaScriptWithScope(String name, String code) {
        this.state.name(name).value(code);
    }

    @Override
    public void writeMaxKey() {
        this.state.value(new BsonMaxKey());
    }

    @Override
    public void writeMinKey() {
        this.state.value(new BsonMinKey());
    }

    @Override
    public void writeName(String name) {
        this.state.name(name);
    }

    @Override
    public void writeNull() {
        this.state.value(null);
    }

    @Override
    public void writeNull(String name) {
        this.writeName(name);
        this.state.value(null);
    }

    @Override
    public void writeObjectId(ObjectId objectId) {
        this.state.value(objectId);
    }

    @Override
    public void writeStartArray(String name) {
        this.writeName(name);
        this.writeStartArray();
    }

    @Override
    public void writeObjectId(String name, ObjectId objectId) {
        this.state.name(name).value(objectId);
    }

    @Override
    public void writeRegularExpression(BsonRegularExpression regularExpression) {
        this.state.value(regularExpression);
    }

    @Override
    public void writeRegularExpression(String name, BsonRegularExpression regularExpression) {
        this.state.name(name).value(regularExpression);
    }

    @Override
    public void writeStartArray() {
        ++this.arraysLevel;
        this.state.array();
    }

    @Override
    public void writeStartDocument() {
        ++this.docsLevel;
        this.state.document();
    }

    @Override
    public void writeSymbol(String name, String value) {
        this.writeName(name);
        this.writeSymbol(value);
    }

    @Override
    public void writeStartDocument(String name) {
        this.state.name(name).document();
        ++this.docsLevel;
    }

    @Override
    public void writeString(String value) {
        this.state.value(value);
    }

    @Override
    public void writeString(String name, String value) {
        this.state.name(name).value(value);
    }

    @Override
    public void writeUndefined(String name) {
        this.writeName(name);
        this.writeUndefined();
    }

    @Override
    public void pipe(BsonReader reader) {
        throw new UnsupportedOperationException("org.bson.io.TestingDocumentWriter.pipe has not yet been implemented.");
    }

    @Override
    public void writeSymbol(String value) {
        this.state.value(new BsonSymbol(value));
    }

    @Override
    public void writeTimestamp(BsonTimestamp value) {
        this.state.value(value);
    }

    @Override
    public void writeTimestamp(String name, BsonTimestamp value) {
        this.writeName(name);
        this.state.value(value);
    }

    @Override
    public void writeUndefined() {
        this.state.value(new BsonUndefined());
    }

    public String toString() {
        return this.root.toString();
    }

    WriteState state(WriteState state) {
        WriteState previous = this.state;
        this.state = state;
        return previous;
    }
}

