/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.references;

import dev.morphia.annotations.IdGetter;
import dev.morphia.mapping.codec.references.MorphiaProxy;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.mapping.lazy.proxy.ReferenceException;
import dev.morphia.sofia.Sofia;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;

public class ReferenceProxy
implements MorphiaProxy,
InvocationHandler {
    private static final List<String> NONFETCHES = List.of("isEmpty", "size");
    private final MorphiaReference<?> reference;

    ReferenceProxy(MorphiaReference<?> reference) {
        this.reference = reference;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        if (method.getName().equals("isFetched")) {
            return this.isFetched();
        }
        if (method.getAnnotation(IdGetter.class) != null) {
            return this.reference.getIds().get(0);
        }
        if ("isEmpty".equals(method.getName())) {
            return this.isFetched() ? this.invoke(method, args2) : Boolean.valueOf(this.reference.getIds().isEmpty());
        }
        if ("size".equals(method.getName())) {
            return this.isFetched() ? this.invoke(method, args2) : Integer.valueOf(this.reference.getIds().size());
        }
        this.fetch(method);
        return this.invoke(method, args2);
    }

    @Override
    public boolean isFetched() {
        return this.reference.isResolved();
    }

    @Override
    public <T> T unwrap() {
        return (T)this.reference.get();
    }

    private Object invoke(Method method, Object[] args2) throws InvocationTargetException, IllegalAccessException {
        if (method.getDeclaringClass().isAssignableFrom(this.getClass())) {
            return method.invoke((Object)this, args2);
        }
        if (this.isFetched()) {
            Object target = this.reference.get();
            if (target == null) {
                throw new ReferenceException(Sofia.missingReferencedEntity(this.reference.getType(), new Locale[0]));
            }
            return method.invoke(target, args2);
        }
        return method.invoke(this.reference.getIds(), args2);
    }

    private void fetch(Method method) {
        if (!this.isFetched() && !NONFETCHES.contains(method.getName())) {
            this.reference.get();
        }
    }
}

