/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.references;

import com.mongodb.DBRef;
import com.mongodb.client.MongoCollection;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.Key;
import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.annotations.Reference;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.BaseReferenceCodec;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyHandler;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.pojo.TypeData;
import dev.morphia.mapping.codec.reader.DocumentReader;
import dev.morphia.mapping.codec.references.MorphiaProxy;
import dev.morphia.mapping.codec.references.ReferenceProxy;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.mapping.experimental.ListReference;
import dev.morphia.mapping.experimental.MapReference;
import dev.morphia.mapping.experimental.MorphiaReference;
import dev.morphia.mapping.experimental.SetReference;
import dev.morphia.mapping.experimental.SingleReference;
import dev.morphia.mapping.lazy.proxy.ReferenceException;
import dev.morphia.query.QueryException;
import dev.morphia.sofia.Sofia;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;

public class ReferenceCodec
extends BaseReferenceCodec<Object>
implements PropertyHandler {
    private final Reference annotation;
    private final BsonTypeClassMap bsonTypeClassMap = new BsonTypeClassMap();
    private final Mapper mapper;
    private final TypeCache<TypeCache.SimpleKey> typeCache = new TypeCache.WithInlineExpunction<TypeCache.SimpleKey>(TypeCache.Sort.SOFT);
    private static final String FIELD_INVOCATION_HANDLER = "handler";

    public ReferenceCodec(Datastore datastore, PropertyModel propertyModel) {
        super(datastore, propertyModel);
        this.mapper = datastore.getMapper();
        this.annotation = propertyModel.getAnnotation(Reference.class);
    }

    public static Object encodeId(Mapper mapper, Datastore datastore, Object value, PropertyModel model) {
        MongoCollection<Object> collection;
        Object idValue;
        if (value instanceof Key) {
            idValue = ((Key)value).getId();
            String collectionName = ((Key)value).getCollection();
            Class type2 = ((Key)value).getType();
            if (collectionName == null || type2 == null) {
                throw new QueryException("Missing type or collection information in key");
            }
            collection = datastore.getDatabase().getCollection(collectionName, type2);
        } else {
            idValue = mapper.getId(value);
            if (idValue == null) {
                if (!mapper.isMappable(value.getClass())) {
                    return value;
                }
                throw new QueryException("No ID value found on referenced entity.  Save referenced entities before defining references to them.");
            }
            collection = mapper.getCollection(value.getClass());
        }
        String valueCollectionName = collection.getNamespace().getCollectionName();
        Reference annotation = model.getAnnotation(Reference.class);
        if (annotation != null && !annotation.idOnly()) {
            idValue = new DBRef(valueCollectionName, idValue);
        }
        return idValue;
    }

    @Nullable
    public static Object encodeId(Mapper mapper, Object value, EntityModel model) {
        Class<Object> type2;
        Object idValue;
        if (value instanceof Key) {
            idValue = ((Key)value).getId();
            String collectionName = ((Key)value).getCollection();
            Class<Object> clazz = type2 = collectionName != null ? mapper.getClassFromCollection(collectionName) : ((Key)value).getType();
            if (type2 == null) {
                throw new MappingException("The type for the reference could not be determined for the key " + value);
            }
        } else {
            idValue = mapper.getId(value);
            if (idValue == null) {
                return !mapper.isMappable(value.getClass()) ? value : null;
            }
            type2 = value.getClass();
        }
        MongoCollection<?> collection = mapper.getCollection(type2);
        String valueCollectionName = collection.getNamespace().getCollectionName();
        String fieldCollectionName = model.getCollectionName();
        Reference annotation = model.getAnnotation(Reference.class);
        if (annotation != null && !annotation.idOnly() || !valueCollectionName.equals(fieldCollectionName)) {
            idValue = new DBRef(valueCollectionName, idValue);
        }
        return idValue;
    }

    @NonNull
    public static Object processId(Object decode, Mapper mapper, DecoderContext decoderContext) {
        ArrayList<Object> id = decode;
        if (id instanceof Iterable) {
            Iterable iterable = id;
            ArrayList<Object> ids = new ArrayList<Object>();
            for (Object o : iterable) {
                ids.add(ReferenceCodec.processId(o, mapper, decoderContext));
            }
            id = ids;
        } else if (id instanceof Document) {
            Document document = (Document)((Object)id);
            if (document.containsKey("$ref")) {
                id = ReferenceCodec.processId(new DBRef(document.getString("$db"), document.getString("$ref"), document.get("$id")), mapper, decoderContext);
            } else if (document.containsKey(mapper.getOptions().getDiscriminatorKey())) {
                try {
                    id = mapper.getCodecRegistry().get(mapper.getClass(document)).decode(new DocumentReader(document), decoderContext);
                }
                catch (CodecConfigurationException e) {
                    throw new MappingException(Sofia.cannotFindTypeInDocument(new Locale[0]), e);
                }
            }
        } else if (id instanceof DBRef) {
            DBRef ref = (DBRef)((Object)id);
            Object refId = ref.getId();
            if (refId instanceof Document) {
                refId = mapper.getCodecRegistry().get(Object.class).decode(new DocumentReader((Document)refId), decoderContext);
            }
            id = new DBRef(ref.getDatabaseName(), ref.getCollectionName(), refId);
        }
        return id;
    }

    @Override
    @Nullable
    public Object decode(BsonReader reader, DecoderContext decoderContext) {
        Object decode = this.getDatastore().getMapper().getCodecRegistry().get(this.bsonTypeClassMap.get(reader.getCurrentBsonType())).decode(reader, decoderContext);
        decode = ReferenceCodec.processId(decode, this.getDatastore().getMapper(), decoderContext);
        return this.fetch(decode);
    }

    private static TypeCache.SimpleKey getCacheKey(Class<?> type2) {
        return new TypeCache.SimpleKey(type2, Arrays.asList(type2.getInterfaces()));
    }

    @Override
    public void encode(BsonWriter writer, Object instance, EncoderContext encoderContext) {
        Object idValue = this.collectIdValues(instance);
        if (idValue == null) {
            throw new ReferenceException(Sofia.noIdForReference(new Locale[0]));
        }
        Codec<?> codec = this.getDatastore().getMapper().getCodecRegistry().get(idValue.getClass());
        codec.encode(writer, idValue, encoderContext);
    }

    @Override
    public Class getEncoderClass() {
        TypeData<?> type2 = this.getTypeData();
        List<TypeData<?>> typeParameters = type2.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            type2 = typeParameters.get(typeParameters.size() - 1);
        }
        return type2.getType();
    }

    private Object collectIdValues(Object value) {
        if (value instanceof Collection) {
            ArrayList<Object> ids = new ArrayList<Object>(((Collection)value).size());
            for (Object o : (Collection)value) {
                ids.add(this.collectIdValues(o));
            }
            return ids;
        }
        if (value instanceof Map) {
            LinkedHashMap<String, Object> ids = new LinkedHashMap<String, Object>();
            Map map = (Map)value;
            for (Map.Entry o : map.entrySet()) {
                ids.put(o.getKey().toString(), this.collectIdValues(o.getValue()));
            }
            return ids;
        }
        if (value.getClass().isArray()) {
            ArrayList<Object> ids = new ArrayList<Object>(((Object[])value).length);
            for (Object o : (Object[])value) {
                ids.add(this.collectIdValues(o));
            }
            return ids;
        }
        return ReferenceCodec.encodeId(this.getDatastore().getMapper(), this.getDatastore(), value, this.getPropertyModel());
    }

    @Override
    public Object encode(@Nullable Object value) {
        try {
            DocumentWriter writer = new DocumentWriter(this.mapper);
            ExpressionHelper.document(writer, () -> {
                writer.writeName("ref");
                this.encode((BsonWriter)writer, value, EncoderContext.builder().build());
            });
            return writer.getDocument().get("ref");
        }
        catch (ReferenceException e) {
            return value;
        }
    }

    private <T> T createProxy(MorphiaReference<?> reference) {
        ReferenceProxy referenceProxy = new ReferenceProxy(reference);
        PropertyModel propertyModel = this.getPropertyModel();
        try {
            Class<?> type2 = propertyModel.getType();
            Class<?> proxyClass = this.typeCache.findOrInsert(type2.getClassLoader(), ReferenceCodec.getCacheKey(type2), () -> this.makeProxy(), this.typeCache);
            Object proxy = proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field field = proxyClass.getDeclaredField(FIELD_INVOCATION_HANDLER);
            field.setAccessible(true);
            field.set(proxy, referenceProxy);
            return (T)proxy;
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new MappingException(e.getMessage(), e);
        }
    }

    private <T> Class<T> makeProxy() {
        PropertyModel propertyModel = this.getPropertyModel();
        Class<?> type2 = propertyModel.getType();
        DynamicType.Builder builder = new ByteBuddy().subclass(type2).implement(new Type[]{MorphiaProxy.class}).name(String.format("%s$%s$$ReferenceProxy", propertyModel.getEntityModel().getName(), propertyModel.getName()));
        ElementMatcher.Junction matcher = ElementMatchers.isDeclaredBy(type2);
        if (!type2.isInterface()) {
            for (type2 = type2.getSuperclass(); type2 != null && !type2.equals(Object.class); type2 = type2.getSuperclass()) {
                matcher = matcher.or(ElementMatchers.isDeclaredBy(type2));
            }
        }
        return builder.invokable(matcher.or(ElementMatchers.isDeclaredBy(MorphiaProxy.class))).intercept(InvocationHandlerAdapter.toField(FIELD_INVOCATION_HANDLER)).defineField(FIELD_INVOCATION_HANDLER, (Type)((Object)InvocationHandler.class), Visibility.PRIVATE).make().load(Thread.currentThread().getContextClassLoader(), ClassLoadingStrategy.Default.WRAPPER).getLoaded();
    }

    @Nullable
    private Object fetch(Object value) {
        Class<?> type2 = this.getPropertyModel().getType();
        MorphiaReference<?> reference = List.class.isAssignableFrom(type2) ? this.readList((List)value) : (Map.class.isAssignableFrom(type2) ? this.readMap((Map)value) : (Set.class.isAssignableFrom(type2) ? this.readSet((List)value) : (type2.isArray() ? this.readList((List)value) : (value instanceof Document ? this.readDocument((Document)value) : this.readSingle(value)))));
        reference.ignoreMissing(this.annotation.ignoreMissing());
        return !this.annotation.lazy() ? reference.get() : this.createProxy(reference);
    }

    private List<?> mapToEntitiesIfNecessary(List<?> value) {
        Mapper mapper = this.getDatastore().getMapper();
        Codec<?> codec = mapper.getCodecRegistry().get(this.getEntityModelForField().getType());
        return value.stream().filter(v -> v instanceof Document && ((Document)v).containsKey("_id")).map(d -> codec.decode(new DocumentReader((Document)d), DecoderContext.builder().build())).collect(Collectors.toList());
    }

    MorphiaReference<?> readDocument(Document value) {
        Mapper mapper = this.getDatastore().getMapper();
        Object id = mapper.getCodecRegistry().get(Object.class).decode(new DocumentReader(value), DecoderContext.builder().build());
        return this.readSingle(id);
    }

    MorphiaReference<?> readList(List<?> value) {
        List<?> mapped = this.mapToEntitiesIfNecessary(value);
        return mapped.isEmpty() ? new ListReference(this.getDatastore(), this.getEntityModelForField(), value) : new ListReference(mapped);
    }

    MorphiaReference<?> readMap(Map<Object, Object> value) {
        LinkedHashMap<String, Object> ids = new LinkedHashMap<String, Object>();
        Class<?> keyType = this.getTypeData().getTypeParameters().get(0).getType();
        for (Map.Entry<Object, Object> entry : value.entrySet()) {
            ids.put((String)Conversions.convert(entry.getKey(), keyType), entry.getValue());
        }
        return new MapReference(this.getDatastore(), ids, this.getEntityModelForField());
    }

    MorphiaReference<?> readSet(List<?> value) {
        List<?> mapped = this.mapToEntitiesIfNecessary(value);
        return mapped.isEmpty() ? new SetReference(this.getDatastore(), this.getEntityModelForField(), value) : new SetReference(new LinkedHashSet(mapped));
    }

    MorphiaReference<?> readSingle(Object value) {
        return new SingleReference(this.getDatastore(), this.getEntityModelForField(), value);
    }
}

