/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.reader;

import com.mongodb.lang.Nullable;
import dev.morphia.mapping.codec.BsonTypeMap;
import dev.morphia.mapping.codec.Conversions;
import dev.morphia.mapping.codec.reader.DocumentState;
import dev.morphia.mapping.codec.reader.Mark;
import dev.morphia.mapping.codec.reader.ReaderState;
import dev.morphia.sofia.Sofia;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.UUID;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonReader;
import org.bson.BsonReaderMark;
import org.bson.BsonRegularExpression;
import org.bson.BsonSerializationException;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class DocumentReader
implements BsonReader {
    private static final BsonTypeMap TYPE_MAP = new BsonTypeMap();
    private final ReaderState start;
    private ReaderState current;

    public DocumentReader(Document document) {
        this.start = this.current = new DocumentState(this, document);
    }

    public ReaderState currentState() {
        return this.current;
    }

    @Override
    public BsonType getCurrentBsonType() {
        return this.stage().getCurrentBsonType();
    }

    @Override
    public String getCurrentName() {
        return this.stage().name();
    }

    @Override
    public BsonBinary readBinaryData() {
        Object value = this.stage().value();
        if (value instanceof UUID) {
            return new BsonBinary((UUID)value);
        }
        if (value instanceof Binary) {
            return new BsonBinary(((Binary)value).getType(), ((Binary)value).getData());
        }
        return (BsonBinary)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte peekBinarySubType() {
        BsonReaderMark mark = this.getMark();
        try {
            Object binary = this.stage().value();
            if (binary instanceof UUID) {
                byte by = (byte)((UUID)binary).version();
                return by;
            }
            if (binary instanceof Binary) {
                byte by = ((Binary)binary).getType();
                return by;
            }
            byte by = ((BsonBinary)binary).getType();
            return by;
        }
        finally {
            mark.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int peekBinarySize() {
        BsonReaderMark mark = this.getMark();
        try {
            Object value = this.stage().value();
            if (value instanceof UUID) {
                int n = 16;
                return n;
            }
            if (value instanceof Binary) {
                int n = ((Binary)value).getData().length;
                return n;
            }
            int n = ((BsonBinary)value).getData().length;
            return n;
        }
        finally {
            mark.reset();
        }
    }

    @Override
    public BsonBinary readBinaryData(String name) {
        this.verifyName(name);
        return this.readBinaryData();
    }

    @Override
    public boolean readBoolean() {
        return (Boolean)this.stage().value();
    }

    @Override
    public boolean readBoolean(String name) {
        this.verifyName(name);
        return this.readBoolean();
    }

    @Override
    public BsonType readBsonType() {
        return this.stage().getCurrentBsonType();
    }

    @Override
    public long readDateTime() {
        Long value = Conversions.convert(this.stage().value(), Long.TYPE);
        if (value != null) {
            return value;
        }
        throw new IllegalStateException(Sofia.valueCannotBeNull(new Locale[0]));
    }

    @Override
    public long readDateTime(String name) {
        this.verifyName(name);
        return this.readDateTime();
    }

    @Override
    public double readDouble() {
        return (Double)this.stage().value();
    }

    @Override
    public double readDouble(String name) {
        this.verifyName(name);
        return this.readDouble();
    }

    @Override
    public void readEndArray() {
        this.stage().endArray();
    }

    @Override
    public void readEndDocument() {
        this.stage().endDocument();
    }

    @Override
    public int readInt32() {
        return (Integer)this.stage().value();
    }

    @Override
    public int readInt32(String name) {
        this.verifyName(name);
        return this.readInt32();
    }

    @Override
    public long readInt64() {
        return (Long)this.stage().value();
    }

    @Override
    public long readInt64(String name) {
        this.verifyName(name);
        return this.readInt64();
    }

    @Override
    public Decimal128 readDecimal128() {
        return (Decimal128)this.stage().value();
    }

    @Override
    public Decimal128 readDecimal128(String name) {
        this.verifyName(name);
        return this.readDecimal128();
    }

    @Override
    public String readJavaScript() {
        return ((BsonJavaScript)this.stage().value()).getCode();
    }

    @Override
    public String readJavaScript(String name) {
        this.verifyName(name);
        return this.readJavaScript();
    }

    @Override
    public String readJavaScriptWithScope() {
        return ((BsonJavaScriptWithScope)this.stage().value()).getCode();
    }

    @Override
    public String readJavaScriptWithScope(String name) {
        this.verifyName(name);
        return this.readJavaScriptWithScope();
    }

    @Override
    public void readMaxKey() {
    }

    @Override
    public void readMaxKey(String name) {
        this.verifyName(name);
        this.readMaxKey();
    }

    @Override
    public void readMinKey() {
    }

    @Override
    public void readMinKey(String name) {
        this.verifyName(name);
        this.readMinKey();
    }

    @Override
    public String readName() {
        return this.stage().name();
    }

    @Override
    public void readName(String name) {
        this.verifyName(name);
    }

    @Override
    public void readNull() {
        this.stage().advance();
    }

    @Override
    public void readNull(String name) {
        this.verifyName(name);
        this.readNull();
    }

    @Override
    public ObjectId readObjectId() {
        return (ObjectId)this.stage().value();
    }

    @Override
    public ObjectId readObjectId(String name) {
        this.verifyName(name);
        return this.readObjectId();
    }

    @Override
    public BsonRegularExpression readRegularExpression() {
        return (BsonRegularExpression)this.stage().value();
    }

    @Override
    public BsonRegularExpression readRegularExpression(String name) {
        this.verifyName(name);
        return this.readRegularExpression();
    }

    @Override
    public BsonDbPointer readDBPointer() {
        return (BsonDbPointer)this.stage().value();
    }

    @Override
    public BsonDbPointer readDBPointer(String name) {
        this.verifyName(name);
        return this.readDBPointer();
    }

    @Override
    public void readStartArray() {
        this.stage().startArray();
    }

    @Override
    public void readStartDocument() {
        this.stage().startDocument();
    }

    @Override
    public String readString() {
        return (String)this.stage().value();
    }

    @Override
    public String readString(String name) {
        this.verifyName(name);
        return this.readString();
    }

    @Override
    public String readSymbol() {
        return (String)this.stage().value();
    }

    @Override
    public String readSymbol(String name) {
        this.verifyName(name);
        return this.readSymbol();
    }

    @Override
    public BsonTimestamp readTimestamp() {
        return (BsonTimestamp)this.stage().value();
    }

    @Override
    public BsonTimestamp readTimestamp(String name) {
        this.verifyName(name);
        return this.readTimestamp();
    }

    @Override
    public void readUndefined() {
    }

    @Override
    public void readUndefined(String name) {
        this.verifyName(name);
        this.readUndefined();
    }

    @Override
    public void skipName() {
        this.stage().skipName();
    }

    @Override
    public void skipValue() {
        this.stage().skipValue();
    }

    @Override
    public BsonReaderMark getMark() {
        return new Mark(this, this.stage());
    }

    @Override
    public void close() {
    }

    protected void verifyName(String expectedName) {
        String actualName = this.readName();
        if (!actualName.equals(expectedName)) {
            throw new BsonSerializationException(String.format("Expected element name to be '%s', not '%s'.", expectedName, actualName));
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", DocumentReader.class.getSimpleName() + "[", "]");
        for (ReaderState location = this.start; location != null; location = location.nextState()) {
            if (location == this.current) {
                joiner.add("<<" + location + ">>");
                continue;
            }
            joiner.add(location.toString());
        }
        return joiner.toString();
    }

    BsonType getBsonType(@Nullable Object o) {
        BsonType bsonType;
        BsonType bsonType2 = bsonType = o == null ? BsonType.NULL : TYPE_MAP.get(o.getClass());
        if (bsonType == null) {
            bsonType = o instanceof List ? BsonType.ARRAY : BsonType.UNDEFINED;
        }
        return bsonType;
    }

    void reset(ReaderState bookmark) {
        this.current = bookmark;
    }

    ReaderState stage() {
        return this.current;
    }

    void state(@Nullable ReaderState next2) {
        this.current = next2;
    }
}

