/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Property;
import dev.morphia.annotations.Reference;
import dev.morphia.annotations.Version;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.codec.MorphiaPropertySerialization;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.pojo.TypeData;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import org.bson.assertions.Assertions;
import org.bson.codecs.pojo.PropertyAccessor;

public final class PropertyModelBuilder {
    private final Datastore datastore;
    private final List<String> alternateNames = new ArrayList<String>();
    private PropertyAccessor<? super Object> accessor;
    private List<Annotation> annotations = Collections.emptyList();
    private Boolean discriminatorEnabled;
    private EntityModel owner;
    private String mappedName;
    private int modifiers;
    private String name;
    private TypeData<?> typeData;
    private MorphiaPropertySerialization serialization;

    PropertyModelBuilder(Datastore datastore) {
        this.datastore = datastore;
    }

    public PropertyModelBuilder discoverMappedName(MapperOptions options) {
        Property property = this.getAnnotation(Property.class);
        Reference reference = this.getAnnotation(Reference.class);
        Version version = this.getAnnotation(Version.class);
        if (this.hasAnnotation(Id.class)) {
            this.mappedName("_id");
        } else if (property != null && !property.value().equals(".")) {
            this.mappedName(property.value());
        } else if (reference != null && !reference.value().equals(".")) {
            this.mappedName(reference.value());
        } else if (version != null && !version.value().equals(".")) {
            this.mappedName(version.value());
        } else {
            this.mappedName(options.getFieldNaming().apply(this.name()));
        }
        return this;
    }

    public PropertyAccessor<? super Object> accessor() {
        return this.accessor;
    }

    public PropertyModelBuilder accessor(PropertyAccessor<? super Object> accessor) {
        this.accessor = accessor;
        return this;
    }

    public void alternateName(String name) {
        this.alternateNames.add(name);
    }

    public List<String> alternateNames() {
        return this.alternateNames;
    }

    public PropertyModelBuilder annotations(List<Annotation> annotations) {
        this.annotations = Collections.unmodifiableList(Assertions.notNull("annotations", annotations));
        return this;
    }

    public List<Annotation> annotations() {
        return this.annotations;
    }

    public PropertyModel build() {
        return new PropertyModel(this);
    }

    public Datastore datastore() {
        return this.datastore;
    }

    public PropertyModelBuilder discriminatorEnabled(Boolean discriminatorEnabled) {
        this.discriminatorEnabled = discriminatorEnabled;
        return this;
    }

    public Boolean discriminatorEnabled() {
        return this.discriminatorEnabled;
    }

    @Nullable
    public <A extends Annotation> A getAnnotation(Class<A> type2) {
        for (Annotation annotation : this.annotations) {
            if (!type2.equals(annotation.annotationType())) continue;
            return (A)((Annotation)type2.cast(annotation));
        }
        return null;
    }

    public boolean hasAnnotation(Class<? extends Annotation> type2) {
        for (Annotation annotation : this.annotations) {
            if (!type2.equals(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public PropertyModelBuilder mappedName(String mappedName) {
        this.mappedName = mappedName;
        return this;
    }

    public String mappedName() {
        return this.mappedName;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public PropertyModelBuilder modifiers(int modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PropertyModelBuilder name(String name) {
        this.name = name;
        return this;
    }

    public PropertyModelBuilder owner(EntityModel entityModel) {
        this.owner = entityModel;
        return this;
    }

    public EntityModel owner() {
        return this.owner;
    }

    public PropertyModelBuilder serialization(MorphiaPropertySerialization propertySerialization) {
        this.serialization = Assertions.notNull("propertySerialization", propertySerialization);
        return this;
    }

    public MorphiaPropertySerialization serialization() {
        return this.serialization;
    }

    public String toString() {
        return new StringJoiner(", ", PropertyModelBuilder.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("mappedName='" + this.mappedName + "'").add("typeData=" + this.typeData).add("annotations=" + this.annotations).toString();
    }

    public TypeData<?> typeData() {
        return this.typeData;
    }

    public PropertyModelBuilder typeData(TypeData<?> typeData) {
        this.typeData = Assertions.notNull("typeData", typeData);
        return this;
    }
}

