/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec.pojo;

import dev.morphia.annotations.PostLoad;
import dev.morphia.annotations.PreLoad;
import dev.morphia.mapping.codec.MorphiaInstanceCreator;
import dev.morphia.mapping.codec.pojo.EntityDecoder;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.reader.DocumentReader;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecConfigurationException;

public class LifecycleDecoder
extends EntityDecoder {
    public <T> LifecycleDecoder(MorphiaCodec<T> codec) {
        super(codec);
    }

    @Override
    public Object decode(BsonReader reader, DecoderContext decoderContext) {
        String discriminator;
        Document document = (Document)this.getMorphiaCodec().getRegistry().get(Document.class).decode(reader, decoderContext);
        EntityModel model = this.getMorphiaCodec().getEntityModel();
        if (model.useDiscriminator() && (discriminator = document.getString(model.getDiscriminatorKey())) != null) {
            Class<?> discriminatorClass = this.getMorphiaCodec().getDiscriminatorLookup().lookup(discriminator);
            Codec<?> codec = this.getMorphiaCodec().getRegistry().get(discriminatorClass);
            if (codec instanceof MorphiaCodec) {
                model = ((MorphiaCodec)codec).getEntityModel();
            } else {
                throw new CodecConfigurationException(String.format("Non-entity class used as discriminator: '%s'.", discriminator));
            }
        }
        MorphiaInstanceCreator instanceCreator = model.getInstanceCreator();
        Object entity = instanceCreator.getInstance();
        model.callLifecycleMethods(PreLoad.class, entity, document, this.getMorphiaCodec().getMapper());
        this.decodeProperties(new DocumentReader(document), decoderContext, instanceCreator, model);
        model.callLifecycleMethods(PostLoad.class, entity, document, this.getMorphiaCodec().getMapper());
        return entity;
    }
}

