/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping.codec;

import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public class EnumCodec<T extends Enum<T>>
implements Codec<T> {
    private final Class<T> type;

    public EnumCodec(Class<T> type2) {
        this.type = type2;
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        writer.writeString(((Enum)value).name());
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return Enum.valueOf(this.type, reader.readString());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.type;
    }
}

