/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.mapping;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.lang.Nullable;
import dev.morphia.Datastore;
import dev.morphia.EntityInterceptor;
import dev.morphia.Key;
import dev.morphia.aggregation.experimental.codecs.AggregationCodecProvider;
import dev.morphia.annotations.Embedded;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.experimental.EmbeddedBuilder;
import dev.morphia.mapping.DiscriminatorLookup;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.NotMappableException;
import dev.morphia.mapping.codec.EnumCodecProvider;
import dev.morphia.mapping.codec.MorphiaCodecProvider;
import dev.morphia.mapping.codec.MorphiaTypesCodecProvider;
import dev.morphia.mapping.codec.PrimitiveCodecRegistry;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.EntityModelBuilder;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.mapping.codec.reader.DocumentReader;
import dev.morphia.mapping.codec.references.MorphiaProxy;
import dev.morphia.mapping.codec.writer.DocumentWriter;
import dev.morphia.mapping.validation.MappingValidator;
import dev.morphia.sofia.Sofia;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public class Mapper {
    public static final String IGNORED_FIELDNAME = ".";
    private final Map<Class, EntityModel> mappedEntities = new ConcurrentHashMap<Class, EntityModel>();
    private final ConcurrentHashMap<String, Set<EntityModel>> mappedEntitiesByCollection = new ConcurrentHashMap();
    private final List<EntityInterceptor> interceptors = new LinkedList<EntityInterceptor>();
    private final MapperOptions options;
    private final DiscriminatorLookup discriminatorLookup;
    private final MorphiaCodecProvider morphiaCodecProvider;
    private final Datastore datastore;
    private final CodecRegistry codecRegistry;

    public Mapper(Datastore datastore, CodecRegistry codecRegistry, MapperOptions options) {
        this.datastore = datastore;
        this.options = options;
        this.morphiaCodecProvider = new MorphiaCodecProvider(this, datastore);
        this.discriminatorLookup = new DiscriminatorLookup(options.getClassLoader());
        this.codecRegistry = CodecRegistries.fromProviders(new MorphiaTypesCodecProvider(this), new PrimitiveCodecRegistry(codecRegistry), new EnumCodecProvider(), new AggregationCodecProvider(this), this.morphiaCodecProvider, codecRegistry);
    }

    public void addInterceptor(EntityInterceptor ei) {
        this.interceptors.add(ei);
    }

    public <T> PropertyModel findIdProperty(Class<?> type2) {
        EntityModel entityModel = this.getEntityModel(type2);
        PropertyModel idField = entityModel.getIdProperty();
        if (idField == null) {
            throw new MappingException(Sofia.idRequired(type2.getName(), new Locale[0]));
        }
        return idField;
    }

    public List<EntityModel> map(Class ... entityClasses) {
        return this.map(List.of(entityClasses));
    }

    public MongoCollection enforceWriteConcern(MongoCollection collection, Class type2) {
        WriteConcern applied = this.getWriteConcern(type2);
        return applied != null ? collection.withWriteConcern(applied) : collection;
    }

    public <T> T fromDocument(Class<T> type2, Document document) {
        Class<T> aClass = type2;
        if (document.containsKey(this.options.getDiscriminatorKey())) {
            aClass = this.getClass(document);
        }
        CodecRegistry codecRegistry = this.getCodecRegistry();
        DocumentReader reader = new DocumentReader(document);
        return codecRegistry.get(aClass).decode(reader, DecoderContext.builder().build());
    }

    @Nullable
    public <T> Class<T> getClass(Document document) {
        Class c = null;
        String discriminator = (String)document.get(this.getOptions().getDiscriminatorKey());
        if (discriminator != null) {
            c = this.getClass(discriminator);
        }
        return c;
    }

    public Class getClass(String discriminator) {
        return this.discriminatorLookup.lookup(discriminator);
    }

    public <T> Class<T> getClassFromCollection(String collection) {
        List<EntityModel> classes = this.getClassesMappedToCollection(collection);
        if (classes.size() > 1) {
            Sofia.logMoreThanOneMapper(collection, classes.stream().map((? super T c) -> c.getType().getName()).collect(Collectors.joining(", ")), new Locale[0]);
        }
        return classes.get(0).getType();
    }

    public List<EntityModel> getClassesMappedToCollection(String collection) {
        Set<EntityModel> entities = this.mappedEntitiesByCollection.get(collection);
        if (entities == null || entities.isEmpty()) {
            throw new MappingException(Sofia.collectionNotMapped(collection, new Locale[0]));
        }
        return new ArrayList<EntityModel>(entities);
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public <T> MongoCollection<T> getCollection(Class<T> type2) {
        EntityModel entityModel = this.getEntityModel(type2);
        String collectionName = entityModel.getCollectionName();
        MongoCollection<T> collection = this.datastore.getDatabase().getCollection(collectionName, type2);
        Entity annotation = entityModel.getEntityAnnotation();
        if (annotation != null && WriteConcern.valueOf(annotation.concern()) != null) {
            collection = collection.withWriteConcern(WriteConcern.valueOf(annotation.concern()));
        }
        return collection;
    }

    public DiscriminatorLookup getDiscriminatorLookup() {
        return this.discriminatorLookup;
    }

    public List<EntityModel> map(List<Class> classes) {
        for (Class type2 : classes) {
            if (this.isMappable(type2)) continue;
            throw new MappingException(Sofia.entityOrEmbedded(type2.getName(), new Locale[0]));
        }
        return classes.stream().map(this::getEntityModel).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public EntityModel getEntityModel(Class type2) {
        Class actual = MorphiaProxy.class.isAssignableFrom(type2) ? type2.getSuperclass() : type2;
        EntityModel model = this.mappedEntities.get(actual);
        if (model == null) {
            if (!this.isMappable(actual)) {
                throw new NotMappableException(type2);
            }
            model = this.register(this.createEntityModel(type2));
        }
        return model;
    }

    @Nullable
    public Object getId(@Nullable Object entity) {
        if (entity == null) {
            return null;
        }
        try {
            EntityModel model = this.getEntityModel(entity.getClass());
            PropertyModel idField = model.getIdProperty();
            if (idField != null) {
                return idField.getValue(entity);
            }
        }
        catch (NotMappableException notMappableException) {
            // empty catch block
        }
        return null;
    }

    public Collection<EntityInterceptor> getInterceptors() {
        return this.interceptors;
    }

    @Nullable
    @Deprecated(since="2.0", forRemoval=true)
    public <T> Key<T> getKey(T entity) {
        if (entity instanceof Key) {
            return (Key)entity;
        }
        Object id = this.getId(entity);
        Class<?> aClass = entity.getClass();
        return id == null ? null : new Key(aClass, this.getEntityModel(aClass).getCollectionName(), id);
    }

    @Nullable
    @Deprecated(since="2.0", forRemoval=true)
    public <T> Key<T> getKey(T entity, String collection) {
        if (entity instanceof Key) {
            return (Key)entity;
        }
        Object id = this.getId(entity);
        Class<?> aClass = entity.getClass();
        return id == null ? null : new Key(aClass, collection, id);
    }

    public List<EntityModel> getMappedEntities() {
        return new ArrayList<EntityModel>(this.mappedEntities.values());
    }

    public MapperOptions getOptions() {
        return this.options;
    }

    @Deprecated(since="2.0", forRemoval=true)
    public void setOptions(MapperOptions options) {
    }

    @Nullable
    public WriteConcern getWriteConcern(Class clazz) {
        Entity entityAnn;
        WriteConcern wc = null;
        EntityModel entityModel = this.getEntityModel(clazz);
        if (entityModel != null && (entityAnn = entityModel.getEntityAnnotation()) != null && !entityAnn.concern().isEmpty()) {
            wc = WriteConcern.valueOf(entityAnn.concern());
        }
        return wc;
    }

    public boolean hasInterceptors() {
        return !this.interceptors.isEmpty();
    }

    public <T> boolean isMappable(Class<T> type2) {
        Class<T> actual = MorphiaProxy.class.isAssignableFrom(type2) ? type2.getSuperclass() : type2;
        return this.hasAnnotation(actual, List.of(Entity.class, Embedded.class));
    }

    public boolean isMapped(Class c) {
        return this.mappedEntities.containsKey(c);
    }

    public <A extends Annotation> EntityModel mapExternal(@Nullable A annotation, Class type2) {
        Class actual = MorphiaProxy.class.isAssignableFrom(type2) ? type2.getSuperclass() : type2;
        EntityModel model = this.mappedEntities.get(actual);
        if (model == null) {
            if (annotation == null) {
                annotation = EmbeddedBuilder.builder();
            }
            model = this.register(this.createEntityModel(type2, annotation));
        }
        return model;
    }

    public synchronized void mapPackage(String packageName) {
        try {
            this.getClasses(this.options.getClassLoader(), packageName, this.getOptions().isMapSubPackages()).stream().map((? super T type2) -> {
                try {
                    return this.getEntityModel((Class)type2);
                }
                catch (NotMappableException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Could not get map classes from package " + packageName, e);
        }
    }

    private <T> EntityModel createEntityModel(Class<T> clazz) {
        return new EntityModelBuilder(this.datastore, clazz).build();
    }

    private <T, A extends Annotation> EntityModel createEntityModel(Class<T> clazz, A annotation) {
        return new EntityModelBuilder(this.datastore, annotation, clazz).build();
    }

    public void mapPackageFromClass(Class clazz) {
        this.mapPackage(clazz.getPackage().getName());
    }

    public <T> void refresh(T entity) {
        Codec<T> refreshCodec = this.morphiaCodecProvider.getRefreshCodec(entity, this.getCodecRegistry());
        MongoCollection<?> collection = this.getCollection(entity.getClass());
        PropertyModel idField = this.getEntityModel(entity.getClass()).getIdProperty();
        if (idField == null) {
            throw new MappingException(Sofia.idRequired(entity.getClass().getName(), new Locale[0]));
        }
        Document id = (Document)collection.find(new Document("_id", idField.getValue(entity)), Document.class).iterator().next();
        refreshCodec.decode(new DocumentReader(id), DecoderContext.builder().checkedDiscriminator(true).build());
    }

    public Document toDocument(Object entity) {
        EntityModel entityModel = this.getEntityModel(entity.getClass());
        DocumentWriter writer = new DocumentWriter(this);
        this.getCodecRegistry().get(entityModel.getType()).encode(writer, entity, EncoderContext.builder().build());
        return writer.getDocument();
    }

    @Deprecated(since="2.0", forRemoval=true)
    public String updateCollection(Key key) {
        String collection = key.getCollection();
        Class type2 = key.getType();
        if (collection == null && type2 == null) {
            throw new IllegalStateException("Key is invalid! " + key);
        }
        if (collection == null) {
            collection = this.getEntityModel(type2).getCollectionName();
            key.setCollection(collection);
        }
        return collection;
    }

    public void updateQueryWithDiscriminators(EntityModel model, Document query) {
        Entity annotation = model.getEntityAnnotation();
        if (annotation != null && annotation.useDiscriminator() && !query.containsKey("_id") && !query.containsKey(model.getDiscriminatorKey())) {
            List<EntityModel> subtypes = model.getSubtypes();
            ArrayList<String> values2 = new ArrayList<String>();
            values2.add(model.getDiscriminator());
            if (this.options.isEnablePolymorphicQueries()) {
                for (EntityModel subtype : subtypes) {
                    values2.add(subtype.getDiscriminator());
                }
            }
            query.put(model.getDiscriminatorKey(), (Object)new Document("$in", values2));
        }
    }

    private String discriminatorKey(Class<?> type2) {
        return this.mappedEntities.get(type2).getDiscriminatorKey();
    }

    private List<Class> getClasses(ClassLoader loader, String packageName, boolean mapSubPackages) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        ClassGraph classGraph = new ClassGraph().addClassLoader(loader).enableAllInfo();
        if (mapSubPackages) {
            classGraph.whitelistPackages(packageName);
            classGraph.whitelistPackages(packageName + ".*");
        } else {
            classGraph.whitelistPackagesNonRecursive(packageName);
        }
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo classInfo : scanResult.getAllClasses()) {
                classes.add(Class.forName(classInfo.getName(), true, loader));
            }
        }
        return new ArrayList<Class>(classes);
    }

    private <T> boolean hasAnnotation(Class<T> clazz, List<Class<? extends Annotation>> annotations) {
        for (Class<? extends Annotation> annotation : annotations) {
            if (clazz.getAnnotation(annotation) == null) continue;
            return true;
        }
        return clazz.getSuperclass() != null && this.hasAnnotation(clazz.getSuperclass(), annotations) || Arrays.stream(clazz.getInterfaces()).map((? super T i2) -> this.hasAnnotation((Class)i2, annotations)).reduce(false, (l, r) -> l != false || r != false) != false;
    }

    private EntityModel register(EntityModel entityModel) {
        this.discriminatorLookup.addModel(entityModel);
        this.mappedEntities.put(entityModel.getType(), entityModel);
        if (entityModel.getCollectionName() != null) {
            this.mappedEntitiesByCollection.computeIfAbsent(entityModel.getCollectionName(), s2 -> new CopyOnWriteArraySet()).add(entityModel);
        }
        if (!entityModel.isInterface()) {
            new MappingValidator().validate(this, entityModel);
        }
        return entityModel;
    }
}

