/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions.impls;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.mapping.Mapper;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class SwitchExpression
extends Expression {
    private final List<Pair> branches = new ArrayList<Pair>();
    private Expression defaultCase;

    public SwitchExpression() {
        super("$switch");
    }

    public SwitchExpression branch(Expression caseExpression, Expression then2) {
        this.branches.add(new Pair(caseExpression, then2));
        return this;
    }

    public SwitchExpression defaultCase(Expression caseExpression) {
        this.defaultCase = caseExpression;
        return this;
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> ExpressionHelper.document(writer, this.getOperation(), () -> {
            ExpressionHelper.array(writer, "branches", () -> {
                for (Pair branch : this.branches) {
                    ExpressionHelper.document(writer, () -> {
                        ExpressionHelper.expression(mapper, writer, "case", branch.caseExpression, encoderContext);
                        ExpressionHelper.expression(mapper, writer, "then", branch.then, encoderContext);
                    });
                }
            });
            ExpressionHelper.expression(mapper, writer, "default", this.defaultCase, encoderContext);
        }));
    }

    private static class Pair {
        private final Expression caseExpression;
        private final Expression then;

        public Pair(Expression caseExpression, Expression then2) {
            this.caseExpression = caseExpression;
            this.then = then2;
        }
    }
}

