/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions.impls;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.mapping.Mapper;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class ArrayIndexExpression
extends Expression {
    private final Expression array;
    private final Expression search;
    private Integer start;
    private Integer end;

    public ArrayIndexExpression(Expression array, Expression search) {
        super("$indexOfArray");
        this.array = array;
        this.search = search;
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> ExpressionHelper.array(writer, this.getOperation(), () -> {
            ExpressionHelper.expression(mapper, writer, this.array, encoderContext);
            ExpressionHelper.expression(mapper, writer, this.search, encoderContext);
            ExpressionHelper.value(mapper, writer, this.start, encoderContext);
            ExpressionHelper.value(mapper, writer, this.end, encoderContext);
        }));
    }

    public ArrayIndexExpression end(Integer end) {
        this.end = end;
        return this;
    }

    public ArrayIndexExpression start(Integer start2) {
        this.start = start2;
        return this;
    }
}

