/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.expressions.impls;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.expressions.impls.Expression;
import dev.morphia.mapping.Mapper;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;

public class Accumulator
extends Expression {
    private final List<Expression> expressions = new ArrayList<Expression>();

    public Accumulator(String operation, List<Expression> values2) {
        super(operation);
        this.expressions.addAll(values2);
    }

    @Override
    public void encode(Mapper mapper, BsonWriter writer, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            writer.writeName(this.getOperation());
            if (this.expressions.size() > 1) {
                writer.writeStartArray();
            }
            for (Expression expression : this.expressions) {
                ExpressionHelper.expression(mapper, writer, expression, encoderContext);
            }
            if (this.expressions.size() > 1) {
                writer.writeEndArray();
            }
        });
    }
}

