/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation.experimental.codecs.stages;

import dev.morphia.aggregation.experimental.codecs.ExpressionHelper;
import dev.morphia.aggregation.experimental.stages.Stage;
import dev.morphia.mapping.Mapper;
import dev.morphia.sofia.Sofia;
import java.util.Locale;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public abstract class StageCodec<T extends Stage>
implements Codec<T> {
    private final Mapper mapper;

    protected StageCodec(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public final T decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException(Sofia.encodingOnly(new Locale[0]));
    }

    @Override
    public final void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        ExpressionHelper.document(writer, () -> {
            writer.writeName(value.stageName());
            this.encodeStage(writer, value, encoderContext);
        });
    }

    protected abstract void encodeStage(BsonWriter var1, T var2, EncoderContext var3);

    protected CodecRegistry getCodecRegistry() {
        return this.mapper.getCodecRegistry();
    }

    protected Mapper getMapper() {
        return this.mapper;
    }
}

