/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoWriteException;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.Nullable;
import dev.morphia.AdvancedDatastore;
import dev.morphia.Datastore;
import dev.morphia.DeleteOptions;
import dev.morphia.InsertManyOptions;
import dev.morphia.InsertOneOptions;
import dev.morphia.UpdateOptions;
import dev.morphia.VersionMismatchException;
import dev.morphia.aggregation.AggregationPipeline;
import dev.morphia.aggregation.AggregationPipelineImpl;
import dev.morphia.aggregation.experimental.Aggregation;
import dev.morphia.aggregation.experimental.AggregationImpl;
import dev.morphia.annotations.CappedAt;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Validation;
import dev.morphia.annotations.builders.IndexHelper;
import dev.morphia.experimental.MorphiaSession;
import dev.morphia.experimental.MorphiaSessionImpl;
import dev.morphia.internal.SessionConfigurable;
import dev.morphia.mapping.Mapper;
import dev.morphia.mapping.MapperOptions;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.codec.pojo.EntityModel;
import dev.morphia.mapping.codec.pojo.MergingEncoder;
import dev.morphia.mapping.codec.pojo.MorphiaCodec;
import dev.morphia.mapping.codec.pojo.PropertyModel;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.QueryFactory;
import dev.morphia.query.Update;
import dev.morphia.query.UpdateException;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.query.experimental.updates.UpdateOperators;
import dev.morphia.sofia.Sofia;
import dev.morphia.transactions.experimental.MorphiaTransaction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreImpl
implements AdvancedDatastore {
    private static final Logger LOG = LoggerFactory.getLogger(DatastoreImpl.class);
    private final MongoDatabase database;
    private final MongoClient mongoClient;
    private final Mapper mapper;
    private final QueryFactory queryFactory;

    protected DatastoreImpl(MongoClient mongoClient, MapperOptions options, String dbName) {
        MongoDatabase database = mongoClient.getDatabase(dbName);
        this.mapper = new Mapper(this, database.getCodecRegistry(), options);
        this.database = database.withCodecRegistry(this.mapper.getCodecRegistry());
        this.mongoClient = mongoClient;
        this.queryFactory = options.getQueryFactory();
    }

    public DatastoreImpl(MongoDatabase database, MongoClient mongoClient, Mapper mapper, QueryFactory queryFactory) {
        this.database = database;
        this.mongoClient = mongoClient;
        this.mapper = mapper;
        this.queryFactory = queryFactory;
    }

    @Override
    public Aggregation<Document> aggregate(String source) {
        return new AggregationImpl<Document>(this, this.getDatabase().getCollection(source));
    }

    @Override
    public <T> Aggregation<T> aggregate(Class<T> source) {
        return new AggregationImpl<T>(this, source, this.mapper.getCollection(source));
    }

    public AggregationPipeline createAggregation(Class source) {
        return new AggregationPipelineImpl(this, this.mapper.getCollection(source), source);
    }

    @Override
    public <T> DeleteResult delete(T entity) {
        return this.delete(entity, new DeleteOptions().writeConcern(this.mapper.getWriteConcern(entity.getClass())));
    }

    @Override
    public <T> DeleteResult delete(T entity, DeleteOptions options) {
        if (entity instanceof Class) {
            throw new MappingException(Sofia.deleteWithClass(entity.getClass().getName(), new Locale[0]));
        }
        Object id = this.mapper.getId(entity);
        return id != null ? this.find(entity.getClass()).filter(Filters.eq("_id", id)).delete(options) : new NoDeleteResult();
    }

    @Override
    public void enableDocumentValidation() {
        for (EntityModel model : this.mapper.getMappedEntities()) {
            this.enableDocumentValidation(model);
        }
    }

    @Override
    public void ensureCaps() {
        List collectionNames = this.database.listCollectionNames().into(new ArrayList());
        for (EntityModel model : this.mapper.getMappedEntities()) {
            CappedAt cappedAt;
            Entity entityAnnotation = model.getEntityAnnotation();
            if (entityAnnotation == null || (cappedAt = entityAnnotation.cap()).value() <= 0L && cappedAt.count() <= 0L) continue;
            CappedAt cap = entityAnnotation.cap();
            String collName = model.getCollectionName();
            CreateCollectionOptions dbCapOpts = new CreateCollectionOptions().capped(true);
            if (cap.value() > 0L) {
                dbCapOpts.sizeInBytes(cap.value());
            }
            if (cap.count() > 0L) {
                dbCapOpts.maxDocuments(cap.count());
            }
            MongoDatabase database = this.getDatabase();
            if (collectionNames.contains(collName)) {
                Document dbResult = database.runCommand(new Document("collstats", collName));
                if (dbResult.getBoolean("capped").booleanValue()) {
                    LOG.debug("MongoCollection already exists and is capped already; doing nothing. " + dbResult);
                    continue;
                }
                LOG.warn("MongoCollection already exists with same name(" + collName + ") and is not capped; not creating capped version!");
                continue;
            }
            this.getDatabase().createCollection(collName, dbCapOpts);
            LOG.debug("Created capped MongoCollection (" + collName + ") with opts " + dbCapOpts);
        }
    }

    @Override
    public void ensureIndexes() {
        if (this.mapper.getMappedEntities().isEmpty()) {
            Sofia.logNoMappedClasses(new Locale[0]);
        }
        IndexHelper indexHelper = new IndexHelper(this.mapper);
        for (EntityModel model : this.mapper.getMappedEntities()) {
            if (model.getIdProperty() == null) continue;
            indexHelper.createIndex(this.mapper.getCollection(model.getType()), model);
        }
    }

    @Override
    public AggregationPipeline createAggregation(String collection, Class<?> clazz) {
        return new AggregationPipelineImpl(this, this.getDatabase().getCollection(collection), clazz);
    }

    @Override
    public <T> Query<T> createQuery(Class<T> type2, Document q) {
        return this.queryFactory.createQuery((Datastore)this, type2, q);
    }

    @Override
    public <T> Query<T> find(Class<T> type2) {
        return this.queryFactory.createQuery(this, type2);
    }

    @Override
    public <T> Query<T> find(String collection, Class<T> type2) {
        return this.queryFactory.createQuery((Datastore)this, collection, type2);
    }

    @Override
    @Nullable
    public ClientSession findSession(SessionConfigurable<?> configurable) {
        return configurable.clientSession() != null ? configurable.clientSession() : this.getSession();
    }

    @Override
    public <T> Query<T> queryByExample(String collection, T ex) {
        return this.queryByExample(ex);
    }

    @Override
    public String getLoggedQuery(FindOptions options) {
        if (options.isLogQuery()) {
            Document command;
            Document filter;
            String json2 = "{}";
            Document first = (Document)this.getDatabase().getCollection("system.profile").find(new Document("command.comment", "logged query: " + options.getQueryLogId()), Document.class).projection(new Document("command.filter", 1)).first();
            if (first != null && (filter = (Document)(command = (Document)first.get("command")).get("filter")) != null) {
                json2 = filter.toJson(this.mapper.getCodecRegistry().get(Document.class));
            }
            return json2;
        }
        throw new IllegalStateException(Sofia.queryNotLogged(new Locale[0]));
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public <T> void ensureIndexes(Class<T> type2) {
        EntityModel model = this.mapper.getEntityModel(type2);
        IndexHelper indexHelper = new IndexHelper(this.mapper);
        indexHelper.createIndex(this.mapper.getCollection(type2), model);
    }

    @Override
    public <T> Query<T> find(String collection) {
        Class type2 = this.mapper.getClassFromCollection(collection);
        return this.queryFactory.createQuery(this, type2);
    }

    @Override
    public MongoDatabase getDatabase() {
        return this.database;
    }

    @Override
    public <T> void insert(T entity) {
        this.insert(entity, new InsertOneOptions().writeConcern(this.mapper.getWriteConcern(entity.getClass())));
    }

    @Override
    public <T> void insert(T entity, InsertOneOptions options) {
        this.save(entity, options);
    }

    @Override
    public <T> void insert(List<T> entities, InsertManyOptions options) {
        this.save(entities, options);
    }

    @Override
    public <T> T merge(T entity) {
        return this.merge(entity, new InsertOneOptions());
    }

    @Override
    public <T> T merge(T entity, InsertOneOptions options) {
        Update<?> update;
        UpdateResult execute;
        Object id = this.mapper.getId(entity);
        if (id == null) {
            throw new MappingException("Could not get id for " + entity.getClass().getName());
        }
        VersionBumpInfo info = this.updateVersioning(entity);
        Query<?> query = this.find(entity.getClass()).filter(Filters.eq("_id", id));
        if (info.versioned && info.newVersion != -1L) {
            query.filter(Filters.eq(info.versionProperty.getMappedName(), info.oldVersion));
        }
        if ((execute = (update = !options.unsetMissing() ? query.update(UpdateOperators.set(entity), new UpdateOperator[0]) : new MergingEncoder(query, (MorphiaCodec)this.mapper.getCodecRegistry().get(entity.getClass())).encode(entity)).execute(new UpdateOptions().clientSession(this.findSession(options)).writeConcern(options.writeConcern()))).getModifiedCount() != 1L) {
            if (info.versioned) {
                info.rollbackVersion(entity);
                throw new VersionMismatchException(entity.getClass(), id);
            }
            throw new UpdateException("Nothing updated");
        }
        return this.find(entity.getClass()).filter(Filters.eq("_id", id)).iterator(new FindOptions().limit(1)).next();
    }

    @Override
    public <T> Query<T> queryByExample(T example) {
        return this.queryFactory.createQuery((Datastore)this, example.getClass(), this.mapper.toDocument(example));
    }

    @Override
    public <T> void refresh(T entity) {
        this.getMapper().refresh(entity);
    }

    @Override
    public <T> List<T> save(List<T> entities, InsertManyOptions options) {
        if (entities.isEmpty()) {
            return List.of();
        }
        LinkedHashMap<MongoCollection, List> grouped = new LinkedHashMap<MongoCollection, List>();
        ArrayList<T> list = new ArrayList<T>();
        for (T t : entities) {
            Class<?> type2 = t.getClass();
            EntityModel model = this.getMapper().getEntityModel(type2);
            if (this.getMapper().getId(t) != null || model.getVersionProperty() != null) {
                list.add(t);
                continue;
            }
            grouped.computeIfAbsent(this.mapper.getCollection(type2), c -> new ArrayList()).add(t);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            MongoCollection collection = (MongoCollection)entry.getKey();
            ClientSession clientSession = options.clientSession();
            if (clientSession == null) {
                collection.insertMany((List)entry.getValue(), options.getOptions());
                continue;
            }
            collection.insertMany(clientSession, (List)entry.getValue(), options.getOptions());
        }
        InsertOneOptions insertOneOptions = new InsertOneOptions().bypassDocumentValidation(options.getBypassDocumentValidation()).clientSession(this.findSession(options)).writeConcern(options.writeConcern());
        for (Object entity : list) {
            this.save(entity, insertOneOptions);
        }
        return entities;
    }

    @Override
    public <T> T save(T entity) {
        return this.save(entity, new InsertOneOptions().writeConcern(this.mapper.getWriteConcern(entity.getClass())));
    }

    @Override
    public <T> T save(T entity, InsertOneOptions options) {
        this.save(this.mapper.getCollection(entity.getClass()), entity, options);
        return entity;
    }

    @Override
    public MorphiaSession startSession() {
        return new MorphiaSessionImpl(this.mongoClient.startSession(), this.mongoClient, this.database, this.mapper, this.queryFactory);
    }

    @Override
    public MorphiaSession startSession(ClientSessionOptions options) {
        return new MorphiaSessionImpl(this.mongoClient.startSession(options), this.mongoClient, this.database, this.mapper, this.queryFactory);
    }

    @Override
    public <T> T withTransaction(MorphiaTransaction<T> body2) {
        return this.doTransaction(this.startSession(), body2);
    }

    @Override
    public <T> T withTransaction(ClientSessionOptions options, MorphiaTransaction<T> transaction) {
        return this.doTransaction(this.startSession(options), transaction);
    }

    public void enableValidation(EntityModel model, Validation validation) {
        String collectionName = model.getCollectionName();
        if (collectionName == null) {
            throw new MappingException(Sofia.notTopLevelType(new Locale[0]));
        }
        try {
            this.getDatabase().runCommand(new Document("collMod", collectionName).append("validator", Document.parse(validation.value())).append("validationLevel", validation.level().getValue()).append("validationAction", validation.action().getValue()));
        }
        catch (MongoCommandException e) {
            if (e.getCode() == 26) {
                this.getDatabase().createCollection(collectionName, new CreateCollectionOptions().validationOptions(new ValidationOptions().validator(Document.parse(validation.value())).validationLevel(validation.level()).validationAction(validation.action())));
            }
            throw e;
        }
    }

    private <T> T doTransaction(MorphiaSession morphiaSession, MorphiaTransaction<T> body2) {
        try (MorphiaSession morphiaSession2 = morphiaSession;){
            ClientSession session = morphiaSession.getSession();
            if (session == null) {
                throw new IllegalStateException("No session could be found for the transaction.");
            }
            Object object = session.withTransaction(() -> body2.execute(morphiaSession));
            return (T)object;
        }
    }

    private void enableDocumentValidation(EntityModel model) {
        Validation validation = model.getAnnotation(Validation.class);
        String collectionName = model.getCollectionName();
        if (validation != null && collectionName != null) {
            try {
                this.getDatabase().runCommand(new Document("collMod", collectionName).append("validator", Document.parse(validation.value())).append("validationLevel", validation.level().getValue()).append("validationAction", validation.action().getValue()));
            }
            catch (MongoCommandException e) {
                if (e.getCode() == 26) {
                    this.database.createCollection(collectionName, new CreateCollectionOptions().validationOptions(new ValidationOptions().validator(Document.parse(validation.value())).validationLevel(validation.level()).validationAction(validation.action())));
                }
                throw e;
            }
        }
    }

    private <T> void save(MongoCollection collection, T entity, InsertOneOptions options) {
        ClientSession clientSession = this.findSession(options);
        Object id = this.mapper.findIdProperty(entity.getClass()).getValue(entity);
        VersionBumpInfo info = this.updateVersioning(entity);
        try {
            if (id == null || info.versioned && info.newVersion == 1L) {
                if (clientSession == null) {
                    options.prepare(collection).insertOne(entity, options.getOptions());
                } else {
                    options.prepare(collection).insertOne(clientSession, entity, options.getOptions());
                }
            } else {
                UpdateResult updateResult;
                ReplaceOptions updateOptions = new ReplaceOptions().bypassDocumentValidation(options.getBypassDocumentValidation()).upsert(!info.versioned);
                Document filter = new Document("_id", id);
                if (info.versioned) {
                    filter.put(info.versionProperty.getMappedName(), (Object)info.oldVersion);
                }
                UpdateResult updateResult2 = updateResult = clientSession == null ? options.prepare(collection).replaceOne(filter, entity, updateOptions) : options.prepare(collection).replaceOne(clientSession, filter, entity, updateOptions);
                if (info.versioned && updateResult.getModifiedCount() != 1L) {
                    info.rollbackVersion(entity);
                    throw new VersionMismatchException(entity.getClass(), id);
                }
            }
        }
        catch (MongoWriteException e) {
            if (info.versioned) {
                info.rollbackVersion(entity);
            }
            throw e;
        }
    }

    private <T> VersionBumpInfo updateVersioning(T entity) {
        EntityModel entityModel = this.mapper.getEntityModel(entity.getClass());
        PropertyModel versionProperty = entityModel.getVersionProperty();
        if (versionProperty != null) {
            Long value = (Long)versionProperty.getValue(entity);
            long updated = value == null ? 1L : value + 1L;
            versionProperty.setValue(entity, updated);
            return new VersionBumpInfo(versionProperty, value, updated);
        }
        return new VersionBumpInfo();
    }

    private static class VersionBumpInfo {
        private final Long oldVersion;
        private final boolean versioned;
        private final Long newVersion;
        private final PropertyModel versionProperty;

        private VersionBumpInfo() {
            this.versioned = false;
            this.newVersion = null;
            this.oldVersion = null;
            this.versionProperty = null;
        }

        private VersionBumpInfo(PropertyModel versionProperty, @Nullable Long oldVersion, Long newVersion) {
            this.versioned = true;
            this.newVersion = newVersion;
            this.oldVersion = oldVersion;
            this.versionProperty = versionProperty;
        }

        private <T> void rollbackVersion(T entity) {
            if (this.versioned) {
                this.versionProperty.setValue(entity, this.oldVersion);
            }
        }
    }

    private static class NoDeleteResult
    extends DeleteResult {
        private NoDeleteResult() {
        }

        @Override
        public boolean wasAcknowledged() {
            return false;
        }

        @Override
        public long getDeletedCount() {
            return 0L;
        }
    }
}

