/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import com.mongodb.ClientSessionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.lang.Nullable;
import dev.morphia.DeleteOptions;
import dev.morphia.FindAndModifyOptions;
import dev.morphia.InsertManyOptions;
import dev.morphia.InsertOneOptions;
import dev.morphia.InsertOptions;
import dev.morphia.ModifyOptions;
import dev.morphia.UpdateOptions;
import dev.morphia.aggregation.AggregationPipeline;
import dev.morphia.aggregation.experimental.Aggregation;
import dev.morphia.experimental.MorphiaSession;
import dev.morphia.internal.SessionConfigurable;
import dev.morphia.mapping.Mapper;
import dev.morphia.query.FindAndDeleteOptions;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.UpdateOperations;
import dev.morphia.query.UpdateOpsImpl;
import dev.morphia.transactions.experimental.MorphiaTransaction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.Document;

public interface Datastore {
    public Aggregation<Document> aggregate(String var1);

    public <T> Aggregation<T> aggregate(Class<T> var1);

    @Deprecated(since="2.0", forRemoval=true)
    public AggregationPipeline createAggregation(Class<?> var1);

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> Query<T> createQuery(Class<T> type2) {
        return this.find(type2);
    }

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> UpdateOperations<T> createUpdateOperations(Class<T> clazz) {
        return new UpdateOpsImpl<T>(this, clazz, this.getMapper());
    }

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> DeleteResult delete(Query<T> query) {
        return query.delete(new DeleteOptions());
    }

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> DeleteResult delete(Query<T> query, DeleteOptions options) {
        return query.delete(options);
    }

    public <T> DeleteResult delete(T var1);

    public <T> DeleteResult delete(T var1, DeleteOptions var2);

    public void enableDocumentValidation();

    public void ensureCaps();

    public void ensureIndexes();

    public <T> void ensureIndexes(Class<T> var1);

    public <T> Query<T> find(Class<T> var1);

    public <T> Query<T> find(String var1, Class<T> var2);

    public <T> Query<T> find(String var1);

    @Nullable
    @Deprecated(since="2.0", forRemoval=true)
    default public <T> T findAndDelete(Query<T> query) {
        return query.findAndDelete();
    }

    @Nullable
    @Deprecated(since="2.0", forRemoval=true)
    default public <T> T findAndDelete(Query<T> query, FindAndModifyOptions options) {
        return query.findAndDelete(new FindAndDeleteOptions().writeConcern(options.getWriteConcern()).collation(options.getCollation()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).sort(options.getSort()).projection(options.getProjection()));
    }

    @Nullable
    @Deprecated(since="2.0", forRemoval=true)
    default public <T> T findAndModify(Query<T> query, UpdateOperations<T> operations, FindAndModifyOptions options) {
        return query.modify(operations).execute(options);
    }

    @Nullable
    @Deprecated(since="2.0", forRemoval=true)
    default public <T> T findAndModify(Query<T> query, UpdateOperations<T> operations) {
        return query.modify(operations).execute(new ModifyOptions().returnDocument(ReturnDocument.AFTER));
    }

    @Nullable
    public ClientSession findSession(SessionConfigurable<?> var1);

    public MongoDatabase getDatabase();

    @Nullable
    public String getLoggedQuery(FindOptions var1);

    public Mapper getMapper();

    @Nullable
    default public ClientSession getSession() {
        return null;
    }

    public <T> void insert(T var1);

    public <T> void insert(T var1, InsertOneOptions var2);

    default public <T> void insert(List<T> entities) {
        this.insert(entities, new InsertManyOptions());
    }

    public <T> void insert(List<T> var1, InsertManyOptions var2);

    public <T> T merge(T var1);

    public <T> T merge(T var1, InsertOneOptions var2);

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> void merge(T entity, WriteConcern wc) {
        this.merge(entity, new InsertOneOptions().writeConcern(wc));
    }

    public <T> Query<T> queryByExample(T var1);

    public <T> void refresh(T var1);

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> List<T> save(Iterable<T> entities) {
        ArrayList list = new ArrayList();
        entities.forEach(list::add);
        return this.save((T)list);
    }

    default public <T> List<T> save(List<T> entities) {
        return this.save(entities, new InsertManyOptions());
    }

    public <T> List<T> save(List<T> var1, InsertManyOptions var2);

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> List<T> save(Iterable<T> entities, InsertOptions options) {
        ArrayList list = new ArrayList();
        entities.forEach(list::add);
        return this.save(list, options.toInsertManyOptions());
    }

    default public <T> T save(T entity) {
        return this.save(entity, new InsertOneOptions());
    }

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> T save(T entity, InsertOptions options) {
        return this.save(entity, options.toInsertOneOptions());
    }

    public <T> T save(T var1, InsertOneOptions var2);

    public MorphiaSession startSession();

    public MorphiaSession startSession(ClientSessionOptions var1);

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> UpdateResult update(Query<T> query, UpdateOperations<T> operations, UpdateOptions options) {
        return query.update(operations).execute(options);
    }

    @Deprecated(since="2.0", forRemoval=true)
    default public <T> UpdateResult update(Query<T> query, UpdateOperations<T> operations) {
        return query.update(operations).execute(new UpdateOptions().upsert(false).multi(true).writeConcern(this.getMapper().getWriteConcern(query.getEntityClass())));
    }

    public <T> T withTransaction(MorphiaTransaction<T> var1);

    public <T> T withTransaction(ClientSessionOptions var1, MorphiaTransaction<T> var2);
}

