/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.tpl.service;

import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.annotation.sub_erupt.Tpl;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.tpl.annotation.EruptTpl;
import xyz.erupt.tpl.annotation.TplAction;
import xyz.erupt.tpl.engine.EngineTemplate;
import xyz.erupt.tpl.engine.FreemarkerEngine;
import xyz.erupt.tpl.engine.H5Engine;
import xyz.erupt.tpl.engine.ThymeleafEngine;
import xyz.erupt.tpl.engine.VelocityTplEngine;
import xyz.erupt.upms.util.MenuTool;

@Order
@Service
public class EruptTplService
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(EruptTplService.class);
    private final Map<String, Method> tplActions = new LinkedCaseInsensitiveMap();
    private final Map<Tpl.Engine, EngineTemplate<Object>> tplEngines = new HashMap<Tpl.Engine, EngineTemplate<Object>>();
    public static String TPL = "tpl";
    @Resource
    private HttpServletRequest request;

    public void run(ApplicationArguments args) {
        EruptSpringUtil.scannerPackage((String[])EruptApplication.getScanPackage(), (TypeFilter[])new TypeFilter[]{new AnnotationTypeFilter(EruptTpl.class)}, clazz -> {
            for (Method method : clazz.getDeclaredMethods()) {
                TplAction tplAction = method.getAnnotation(TplAction.class);
                if (null == tplAction) continue;
                this.tplActions.put(tplAction.value(), method);
            }
        });
        this.engineLoader();
        MenuTool.addMenuType((VLModel)new VLModel(TPL, "\u6a21\u677f", "tpl\u76ee\u5f55\u4e0b\u6587\u4ef6\u540d"));
        log.info("Erupt tpl initialization complete");
    }

    private void engineLoader() {
        Class[] engineTemplates;
        for (Class tpl : engineTemplates = new Class[]{H5Engine.class, FreemarkerEngine.class, ThymeleafEngine.class, VelocityTplEngine.class}) {
            try {
                EngineTemplate engineTemplate = (EngineTemplate)tpl.newInstance();
                engineTemplate.setEngine(engineTemplate.init());
                this.tplEngines.put(engineTemplate.engine(), engineTemplate);
            }
            catch (NoClassDefFoundError e) {
                return;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Method getAction(String name) {
        return this.tplActions.get(name);
    }

    public void tplRender(Tpl tpl, Map<String, Object> map, HttpServletResponse response) {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        this.tplRender(tpl, map, response.getWriter());
    }

    public void tplRender(Tpl tpl, Map<String, Object> map, Writer writer) {
        if (!tpl.tplHandler().isInterface()) {
            if (null == map) {
                map = new HashMap<String, Object>();
            }
            map.putAll(((Tpl.TplHandler)EruptSpringUtil.getBean((Class)tpl.tplHandler())).bindTplData(tpl.params()));
        }
        this.tplRender(tpl.engine(), tpl.path(), map, writer);
    }

    public void tplRender(Tpl.Engine engine, String path, Map<String, Object> map, Writer writer) {
        if (null == map) {
            map = new HashMap<String, Object>();
        }
        map.put("request", this.request);
        EngineTemplate<Object> engineAbstractTemplate = this.tplEngines.get(engine);
        Assert.notNull(engineAbstractTemplate, (String)(engine.name() + " jar not found"));
        engineAbstractTemplate.render(engineAbstractTemplate.getEngine(), path, map, writer);
    }
}

