/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.tpl.service;

import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.PathMatcher;
import xyz.erupt.annotation.sub_erupt.Tpl;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.tpl.annotation.EruptTpl;
import xyz.erupt.tpl.annotation.TplAction;
import xyz.erupt.tpl.engine.BeetlEngine;
import xyz.erupt.tpl.engine.EngineTemplate;
import xyz.erupt.tpl.engine.EnjoyEngine;
import xyz.erupt.tpl.engine.FreemarkerEngine;
import xyz.erupt.tpl.engine.NativeEngine;
import xyz.erupt.tpl.engine.ThymeleafEngine;
import xyz.erupt.tpl.engine.VelocityTplEngine;

@Order
@Service
public class EruptTplService {
    private static final Logger log = LoggerFactory.getLogger(EruptTplService.class);
    public static String TPL = "tpl";
    private static final Map<Tpl.Engine, EngineTemplate<Object>> tplEngines = new HashMap<Tpl.Engine, EngineTemplate<Object>>();
    private static final Class<?>[] engineTemplates;
    private final Map<String, Method> tplActions = new LinkedCaseInsensitiveMap();
    private final Map<String, Method> tplMatcherActions = new LinkedCaseInsensitiveMap();
    private final PathMatcher pathMatcher = new AntPathMatcher();
    @Resource
    private HttpServletRequest request;
    @Resource
    private HttpServletResponse response;

    public void run() {
        EruptSpringUtil.scannerPackage((String[])EruptApplication.getScanPackage(), (TypeFilter[])new TypeFilter[]{new AnnotationTypeFilter(EruptTpl.class)}, this::registerTpl);
    }

    public void registerTpl(Class<?> tplClass) {
        Arrays.stream(tplClass.getDeclaredMethods()).forEach(method -> Optional.ofNullable(method.getAnnotation(TplAction.class)).ifPresent(it -> {
            if (this.pathMatcher.isPattern(it.value())) {
                this.tplMatcherActions.put(it.value(), (Method)method);
            } else {
                this.tplActions.put(it.value(), (Method)method);
            }
        }));
    }

    public void unregisterTpl(Class<?> tplClass) {
        Arrays.stream(tplClass.getDeclaredMethods()).forEach(method -> Optional.ofNullable(method.getAnnotation(TplAction.class)).ifPresent(it -> {
            this.tplActions.remove(it.value());
            this.tplMatcherActions.remove(it.value());
        }));
    }

    public Method getAction(String path) {
        if (this.tplActions.containsKey(path)) {
            return this.tplActions.get(path);
        }
        for (Map.Entry<String, Method> entry : this.tplMatcherActions.entrySet()) {
            if (!this.pathMatcher.match(entry.getKey(), path)) continue;
            return entry.getValue();
        }
        return null;
    }

    public Object getEngine(Tpl.Engine engine) {
        return tplEngines.get(engine).getEngine();
    }

    public void tplRender(Tpl tpl, Map<String, Object> map, HttpServletResponse response) {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        this.tplRender(tpl, map, response.getWriter());
    }

    public void tplRender(Tpl tpl, Map<String, Object> map, Writer writer) {
        if (!tpl.tplHandler().isInterface()) {
            Tpl.TplHandler tplHandler = (Tpl.TplHandler)EruptSpringUtil.getBean((Class)tpl.tplHandler());
            tplHandler.bindTplData((Map)Optional.ofNullable(map).orElse(new HashMap()), tpl.params());
        }
        this.tplRender(tpl.engine(), tpl.path(), map, writer);
    }

    public void tplRender(Tpl.Engine engine, String path, Map<String, Object> map, Writer writer) {
        map = Optional.ofNullable(map).orElse(new HashMap());
        map.put("request", this.request);
        map.put("response", this.response);
        map.put("base", this.request.getContextPath());
        EngineTemplate<Object> engineAbstractTemplate = tplEngines.get(engine);
        Assert.notNull(engineAbstractTemplate, (String)(engine.name() + " jar not found"));
        engineAbstractTemplate.render(engineAbstractTemplate.getEngine(), path, map, writer);
    }

    static {
        for (Class<?> tpl : engineTemplates = new Class[]{NativeEngine.class, FreemarkerEngine.class, ThymeleafEngine.class, VelocityTplEngine.class, BeetlEngine.class, EnjoyEngine.class}) {
            try {
                EngineTemplate engineTemplate = (EngineTemplate)tpl.newInstance();
                engineTemplate.setEngine(engineTemplate.init());
                tplEngines.put(engineTemplate.engine(), engineTemplate);
            }
            catch (NoClassDefFoundError engineTemplate) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

