/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.service;

import com.google.gson.reflect.TypeToken;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.service.EruptSessionService;

@Service
public class SecurityService {
    @Resource
    private EruptSessionService sessionService;

    public boolean verifyToken(String token) {
        return null != this.sessionService.get("eruptAuth:token:" + token);
    }

    public boolean verifyMenuAuth(String token, String name) {
        List menus = (List)this.sessionService.get("eruptAuth:menu:" + token, new TypeToken<List<EruptMenu>>(){}.getType());
        for (EruptMenu menu : menus) {
            if (!name.equalsIgnoreCase(menu.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean verifyEruptMenuAuth(String token, String authStr, EruptModel eruptModel) {
        if (!authStr.equalsIgnoreCase(eruptModel.getEruptName())) {
            return false;
        }
        if (!eruptModel.getErupt().authVerify()) {
            return true;
        }
        return this.verifyMenuAuth(token, eruptModel.getEruptName());
    }
}

