/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.interceptor;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import xyz.erupt.security.config.EruptSecurityProp;
import xyz.erupt.security.interceptor.RequestWrapper;

@Component
@WebFilter(urlPatterns={"/erupt-api"})
public class HttpServletRequestFilter
implements Filter {
    @Autowired
    private EruptSecurityProp eruptSecurityProp;
    private static final String CONTENT_TYPE_JSON = "application/json";

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request;
        if (this.eruptSecurityProp.isRecordOperateLog() && servletRequest instanceof HttpServletRequest && (request = (HttpServletRequest)servletRequest).getServletPath().contains("/erupt-api") && null != request.getContentType() && CONTENT_TYPE_JSON.equals(request.getContentType())) {
            RequestWrapper requestWrapper = new RequestWrapper(request);
            servletRequest.setAttribute("@req_body@", (Object)requestWrapper.getBody());
            filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

