/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.interceptor;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import xyz.erupt.upms.annotation.EruptLoginAuth;
import xyz.erupt.upms.annotation.EruptMenuAuth;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;

@Component
public class EruptSuperInterceptor
implements AsyncHandlerInterceptor {
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private EruptUserService eruptUserService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (handler instanceof HandlerMethod) {
            String token;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            EruptLoginAuth eruptAuth = (EruptLoginAuth)handlerMethod.getMethodAnnotation(EruptLoginAuth.class);
            EruptMenuAuth eruptMenuAuth = (EruptMenuAuth)handlerMethod.getMethodAnnotation(EruptMenuAuth.class);
            if (!(null == eruptAuth && null == eruptMenuAuth || null != (token = request.getHeader("token")) && null != this.sessionService.get("erupt-auth:token:" + token))) {
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
                response.sendError(HttpStatus.UNAUTHORIZED.value());
                return false;
            }
            if (null != eruptMenuAuth && null == this.eruptUserService.getEruptMenuByValue(eruptMenuAuth.value())) {
                response.setStatus(HttpStatus.FORBIDDEN.value());
                response.sendError(HttpStatus.FORBIDDEN.value());
                return false;
            }
        }
        return true;
    }
}

