/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.security.interceptor;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.context.MetaErupt;
import xyz.erupt.core.context.MetaUser;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.security.service.OperationService;
import xyz.erupt.upms.constant.SessionKey;
import xyz.erupt.upms.prop.EruptUpmsProp;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;

@Service
@Order
public class EruptSecurityInterceptor
implements AsyncHandlerInterceptor {
    @Resource
    private EruptUserService eruptUserService;
    @Resource
    private EruptProp eruptProp;
    @Resource
    private EruptUpmsProp eruptUpmsProp;
    @Resource
    private OperationService operationService;
    private static final String ERUPT_PARENT_HEADER_KEY = "eruptParent";
    private static final String ERUPT_PARENT_PARAM_KEY = "_eruptParent";
    @Resource
    private EruptSessionService sessionService;

    /*
     * Unable to fully structure code
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        eruptRouter = null;
        if (handler instanceof HandlerMethod) {
            handlerMethod = (HandlerMethod)handler;
            eruptRouter = (EruptRouter)handlerMethod.getMethodAnnotation(EruptRouter.class);
        }
        if (null == eruptRouter) {
            return true;
        }
        token = null;
        eruptName = null;
        parentEruptName = null;
        if (eruptRouter.verifyMethod() == EruptRouter.VerifyMethod.HEADER) {
            token = request.getHeader("token");
            eruptName = request.getHeader("erupt");
            parentEruptName = request.getHeader("eruptParent");
        } else if (eruptRouter.verifyMethod() == EruptRouter.VerifyMethod.PARAM) {
            token = request.getParameter("_token");
            eruptName = request.getParameter("_erupt");
            parentEruptName = request.getHeader("_eruptParent");
        }
        if (eruptRouter.verifyType().equals((Object)EruptRouter.VerifyType.ERUPT)) {
            MetaContext.register((MetaErupt)new MetaErupt(eruptName, eruptName));
            erupt = EruptCoreService.getErupt((String)eruptName);
            if (null == erupt) {
                response.setStatus(HttpStatus.NOT_FOUND.value());
                return false;
            }
            if (!erupt.getErupt().authVerify()) {
                return true;
            }
        }
        if (null == token || null == this.sessionService.get("erupt-auth:token:" + token)) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.sendError(HttpStatus.UNAUTHORIZED.value());
            return false;
        }
        metaUserinfo = this.eruptUserService.getSimpleUserInfo();
        MetaContext.registerToken((String)token);
        MetaContext.register((MetaUser)new MetaUser(metaUserinfo.getId() + "", metaUserinfo.getAccount(), metaUserinfo.getUsername()));
        authStr = request.getServletPath().split("/")[eruptRouter.skipAuthIndex() + eruptRouter.authIndex()];
        switch (1.$SwitchMap$xyz$erupt$core$annotation$EruptRouter$VerifyType[eruptRouter.verifyType().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (!eruptRouter.verifyHandler().isInterface()) {
                    authStr = ((EruptRouter.VerifyHandler)EruptSpringUtil.getBean((Class)eruptRouter.verifyHandler())).convertAuthStr(eruptRouter, request, authStr);
                }
                if (null == this.eruptUserService.getEruptMenuByValue(authStr)) {
                    response.setStatus(HttpStatus.FORBIDDEN.value());
                    response.sendError(HttpStatus.FORBIDDEN.value());
                    return false;
                }
                MetaContext.register((MetaErupt)new MetaErupt(null, authStr));
                break;
            }
            case 3: {
                eruptModel = EruptCoreService.getErupt((String)eruptName);
                if (StringUtils.isNotBlank((CharSequence)parentEruptName)) {
                    eruptParentModel = EruptCoreService.getErupt((String)parentEruptName);
                    for (EruptFieldModel model : eruptParentModel.getEruptFieldModels()) {
                        if (!eruptModel.getEruptName().equals(model.getFieldReturnName())) continue;
                        if (authStr.equals(eruptModel.getEruptName())) {
                            authStr = eruptParentModel.getEruptName();
                        }
                        eruptModel = eruptParentModel;
                        ** GOTO lbl64
                    }
                    for (RowOperation operation : eruptParentModel.getErupt().rowOperation()) {
                        if (Void.TYPE == operation.eruptClass() || !eruptModel.getEruptName().equals(operation.eruptClass().getSimpleName())) continue;
                        authStr = eruptParentModel.getEruptName();
                        eruptModel = eruptParentModel;
                        ** GOTO lbl64
                    }
                    response.setStatus(HttpStatus.NOT_FOUND.value());
                    return false;
                }
lbl64:
                // 4 sources

                if (!authStr.equalsIgnoreCase(eruptModel.getEruptName())) {
                    response.setStatus(HttpStatus.NOT_FOUND.value());
                    return false;
                }
                if (null != this.eruptUserService.getEruptMenuByValue(eruptModel.getEruptName())) break;
                response.setStatus(HttpStatus.FORBIDDEN.value());
                response.sendError(HttpStatus.FORBIDDEN.value());
                return false;
            }
        }
        if (this.eruptProp.isRedisSessionRefresh()) {
            for (String uk : SessionKey.USER_KEY_GROUP) {
                this.sessionService.expire(uk + token, (long)this.eruptUpmsProp.getExpireTimeByLogin().intValue(), TimeUnit.MINUTES);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        try {
            this.operationService.record(handler, ex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MetaContext.remove();
        }
    }
}

