/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.magicapi.interceptor;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.ssssssss.magicapi.interceptor.Authorization;
import org.ssssssss.magicapi.interceptor.AuthorizationInterceptor;
import org.ssssssss.magicapi.interceptor.MagicUser;
import org.ssssssss.magicapi.interceptor.RequestInterceptor;
import org.ssssssss.magicapi.model.ApiInfo;
import org.ssssssss.magicapi.model.JsonBean;
import org.ssssssss.magicapi.model.Options;
import org.ssssssss.script.MagicScriptContext;
import xyz.erupt.upms.cache.CaffeineEruptCache;
import xyz.erupt.upms.cache.IEruptCache;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptUserService;

@Component
public class EruptMagicAPIRequestInterceptor
implements RequestInterceptor,
AuthorizationInterceptor {
    private final EruptUserService eruptUserService;
    private final EruptContextService eruptContextService;
    private final IEruptCache<EruptUser> eruptUserIEruptCache = new CaffeineEruptCache(600000L);

    public EruptMagicAPIRequestInterceptor(EruptUserService eruptUserService, EruptContextService eruptContextService) {
        this.eruptUserService = eruptUserService;
        this.eruptContextService = eruptContextService;
    }

    public boolean requireLogin() {
        return false;
    }

    public Object preHandle(ApiInfo info, MagicScriptContext context, HttpServletRequest request, HttpServletResponse response) {
        boolean isLogin;
        String permission = Objects.toString(info.getOptionValue(Options.PERMISSION), "");
        String role = Objects.toString(info.getOptionValue(Options.ROLE), "");
        String login = Objects.toString(info.getOptionValue(Options.REQUIRE_LOGIN), "");
        boolean bl = isLogin = this.eruptUserService.getCurrentUid() != null;
        if (StringUtils.isNotBlank((CharSequence)login) && !isLogin) {
            return new JsonBean(401, "\u7528\u6237\u672a\u767b\u5f55");
        }
        if (StringUtils.isNotBlank((CharSequence)role) || StringUtils.isNotBlank((CharSequence)permission)) {
            if (!isLogin) {
                return new JsonBean(401, "\u7528\u6237\u672a\u767b\u5f55");
            }
            EruptUser user = (EruptUser)this.eruptUserIEruptCache.get(this.eruptContextService.getCurrentToken(), key -> this.eruptUserService.getCurrentEruptUser());
            if (StringUtils.isNotBlank((CharSequence)permission) && this.eruptUserService.getEruptMenuByValue(permission) == null) {
                return new JsonBean(403, "\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            }
            if (StringUtils.isNotBlank((CharSequence)role) && user.getRoles().stream().noneMatch(it -> role.equals(it.getCode()))) {
                return new JsonBean(403, "\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            }
        }
        return null;
    }

    public boolean allowVisit(MagicUser magicUser, HttpServletRequest request, Authorization authorization) {
        return this.eruptUserService.getCurrentUid() != null && this.eruptUserService.getEruptMenuByValue("ERUPT_MAGIC_" + authorization.name()) != null;
    }
}

