/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.service;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.core.annotation.Order;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.config.Comment;
import xyz.erupt.core.annotation.EruptDataSource;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.prop.EruptPropDb;

@Service
@Order
public class EntityManagerService
implements ApplicationRunner {
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private EruptProp eruptProp;
    private Map<String, EntityManagerFactory> entityManagerMap;

    public void run(ApplicationArguments args) {
        if (null != this.eruptProp.getDbs()) {
            this.entityManagerMap = new HashMap<String, EntityManagerFactory>();
            for (EruptPropDb prop : this.eruptProp.getDbs()) {
                Objects.requireNonNull(prop.getDatasource().getName(), "dbs configuration Must specify name \u2192 dbs.datasource.name");
                Objects.requireNonNull(prop.getScanPackages(), String.format("%s DataSource not found 'scanPackages' configuration", prop.getDatasource().getName()));
                LocalContainerEntityManagerFactoryBean factory = new LocalContainerEntityManagerFactoryBean();
                JpaProperties jpa = prop.getJpa();
                HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
                vendorAdapter.setGenerateDdl(jpa.isGenerateDdl());
                vendorAdapter.setDatabase(jpa.getDatabase());
                vendorAdapter.setShowSql(jpa.isShowSql());
                vendorAdapter.setDatabasePlatform(jpa.getDatabasePlatform());
                factory.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
                Properties properties = new Properties();
                properties.putAll((Map<?, ?>)jpa.getProperties());
                factory.setJpaProperties(properties);
                HikariConfig hikariConfig = prop.getDatasource().getHikari().toHikariConfig();
                Optional.ofNullable(prop.getDatasource().getUrl()).ifPresent(arg_0 -> ((HikariConfig)hikariConfig).setJdbcUrl(arg_0));
                Optional.ofNullable(prop.getDatasource().getDriverClassName()).ifPresent(arg_0 -> ((HikariConfig)hikariConfig).setDriverClassName(arg_0));
                Optional.ofNullable(prop.getDatasource().getUsername()).ifPresent(arg_0 -> ((HikariConfig)hikariConfig).setUsername(arg_0));
                Optional.ofNullable(prop.getDatasource().getPassword()).ifPresent(arg_0 -> ((HikariConfig)hikariConfig).setPassword(arg_0));
                Optional.ofNullable(prop.getDatasource().getHikari().getPoolName()).ifPresent(arg_0 -> ((HikariConfig)hikariConfig).setPoolName(arg_0));
                factory.setDataSource((DataSource)new HikariDataSource(hikariConfig));
                factory.setPackagesToScan(prop.getScanPackages());
                factory.afterPropertiesSet();
                this.entityManagerMap.put(prop.getDatasource().getName(), factory.getObject());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R getEntityManager(Class<?> eruptClass, Function<EntityManager, R> function) {
        EruptDataSource eruptDataSource = eruptClass.getAnnotation(EruptDataSource.class);
        if (null == eruptDataSource) {
            return function.apply(this.entityManager);
        }
        EntityManager em = this.entityManagerMap.get(eruptDataSource.value()).createEntityManager();
        try {
            R r = function.apply(em);
            return r;
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerTran(Class<?> eruptClass, Consumer<EntityManager> consumer) {
        EruptDataSource eruptDataSource = eruptClass.getAnnotation(EruptDataSource.class);
        if (null == eruptDataSource) {
            consumer.accept(this.entityManager);
            return;
        }
        EntityManager em = this.entityManagerMap.get(eruptDataSource.value()).createEntityManager();
        try {
            em.getTransaction().begin();
            consumer.accept(em);
            em.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            em.getTransaction().rollback();
        }
        finally {
            if (em.isOpen()) {
                em.close();
            }
        }
    }

    @Comment(value="\u5fc5\u987b\u624b\u52a8\u6267\u884c close() \u65b9\u6cd5")
    public EntityManager findEntityManager(String name) {
        return this.entityManagerMap.get(name).createEntityManager();
    }
}

