/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.dao;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import xyz.erupt.annotation.query.Condition;
import xyz.erupt.annotation.sub_erupt.Filter;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.core.query.EruptQuery;
import xyz.erupt.core.util.AnnotationUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;

public class EruptJpaUtils {
    public static final String L_VAL_KEY = "l_";
    public static final String R_VAL_KEY = "r_";
    public static final String PERCENT = "%";
    public static final String AND = " and ";
    public static final String AS = " as ";
    public static final String LEFT_JOIN = " left outer join ";

    public static Set<String> getEruptColJpaKeys(EruptModel eruptModel) {
        HashSet<String> cols = new HashSet<String>();
        String eruptNameSymbol = eruptModel.getEruptName() + ".";
        cols.add(eruptNameSymbol + eruptModel.getErupt().primaryKeyCol() + AS + eruptModel.getErupt().primaryKeyCol());
        eruptModel.getEruptFieldModels().forEach(field -> {
            if (null != field.getField().getAnnotation(OneToMany.class) || null != field.getField().getAnnotation(ManyToMany.class)) {
                return;
            }
            if (null != field.getField().getAnnotation(Transient.class)) {
                return;
            }
            for (View view : field.getEruptField().views()) {
                if (view.column().length() == 0) {
                    cols.add(eruptNameSymbol + field.getFieldName() + AS + field.getFieldName());
                    continue;
                }
                cols.add(eruptNameSymbol + field.getFieldName() + "." + view.column() + AS + field.getFieldName() + "_" + view.column().replace(".", "_"));
            }
        });
        return cols;
    }

    public static String generateEruptJpaHql(EruptModel eruptModel, String cols, EruptQuery query, boolean countSql) {
        StringBuilder hql = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)cols)) {
            hql.append("select ").append(cols).append(" from ").append(eruptModel.getEruptName()).append(AS).append(eruptModel.getEruptName());
            hql.append(EruptJpaUtils.generateEruptJoinHql(eruptModel));
        } else {
            hql.append("from ").append(eruptModel.getEruptName());
        }
        hql.append(EruptJpaUtils.geneEruptHqlCondition(eruptModel, query.getConditions(), query.getConditionStrings()));
        if (!countSql) {
            hql.append(EruptJpaUtils.geneEruptHqlOrderBy(eruptModel, query.getOrderBy()));
        }
        return hql.toString();
    }

    public static String generateEruptJoinHql(EruptModel eruptModel) {
        StringBuffer hql = new StringBuffer();
        ReflectUtil.findClassAllFields((Class)eruptModel.getClazz(), field -> {
            EruptFieldModel model;
            if ((null != field.getAnnotation(ManyToOne.class) || null != field.getAnnotation(OneToOne.class)) && (model = (EruptFieldModel)eruptModel.getEruptFieldMap().get(field.getName())) != null) {
                View[] views;
                HashSet<String> pathSet = new HashSet<String>();
                for (View v : views = model.getEruptField().views()) {
                    String columnPath = v.column();
                    if (columnPath.contains(".")) {
                        String path = eruptModel.getEruptName() + "." + field.getName() + "." + columnPath.substring(0, columnPath.lastIndexOf("."));
                        if (pathSet.contains(path)) continue;
                        hql.append(LEFT_JOIN).append(path);
                        pathSet.add(path);
                        continue;
                    }
                    hql.append(LEFT_JOIN).append(eruptModel.getEruptName()).append(".").append(field.getName()).append(AS).append(field.getName());
                }
            }
        });
        return hql.toString();
    }

    public static String geneEruptHqlCondition(EruptModel eruptModel, List<Condition> conditions, List<String> customCondition) {
        StringBuilder hql = new StringBuilder();
        hql.append(" where 1 = 1 ");
        if (null != conditions) {
            for (Condition condition : conditions) {
                EruptFieldModel eruptFieldModel = (EruptFieldModel)eruptModel.getEruptFieldMap().get(condition.getKey());
                if (null != eruptFieldModel) {
                    Edit edit = eruptFieldModel.getEruptField().edit();
                    if (edit.type() == EditType.REFERENCE_TREE) {
                        hql.append(AND).append(condition.getKey()).append(".").append(edit.referenceTreeType().id()).append("=:").append(condition.getKey());
                        continue;
                    }
                    if (edit.type() == EditType.REFERENCE_TABLE) {
                        hql.append(AND).append(condition.getKey()).append(".").append(edit.referenceTableType().id()).append("=:").append(condition.getKey());
                        continue;
                    }
                    String _key = EruptJpaUtils.completeHqlPath(eruptModel.getEruptName(), condition.getKey());
                    switch (condition.getExpression()) {
                        case EQ: {
                            hql.append(AND).append(_key).append("=:").append(condition.getKey());
                            break;
                        }
                        case LIKE: {
                            hql.append(AND).append(_key).append(" like :").append(condition.getKey());
                            break;
                        }
                        case RANGE: {
                            hql.append(AND).append(_key).append(" between :").append(L_VAL_KEY).append(condition.getKey()).append(" and :").append(R_VAL_KEY).append(condition.getKey());
                            break;
                        }
                        case IN: {
                            hql.append(AND).append(_key).append(" in (:").append(condition.getKey()).append(")");
                        }
                    }
                    continue;
                }
                hql.append(AND).append(condition.getKey()).append("=:").append(condition.getKey());
            }
        }
        AnnotationUtil.switchFilterConditionToStr((Filter[])eruptModel.getErupt().filter()).forEach(it -> {
            if (StringUtils.isNotBlank((CharSequence)it)) {
                hql.append(AND).append((String)it);
            }
        });
        Optional.ofNullable(customCondition).ifPresent(it -> it.forEach(str -> {
            if (StringUtils.isNotBlank((CharSequence)str)) {
                hql.append(AND).append((String)str);
            }
        }));
        return hql.toString();
    }

    public static String geneEruptHqlOrderBy(EruptModel eruptModel, String orderBy) {
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            return " order by " + EruptJpaUtils.completeHqlPath(eruptModel.getEruptName(), orderBy);
        }
        if (StringUtils.isNotBlank((CharSequence)eruptModel.getErupt().orderBy())) {
            return " order by " + EruptJpaUtils.completeHqlPath(eruptModel.getEruptName(), eruptModel.getErupt().orderBy());
        }
        return "";
    }

    public static String completeHqlPath(String eruptName, String hqlPath) {
        if (hqlPath.contains(".")) {
            return hqlPath;
        }
        return eruptName + "." + hqlPath;
    }
}

