/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.Query;
import org.springframework.stereotype.Repository;
import xyz.erupt.annotation.query.Condition;
import xyz.erupt.core.annotation.EruptDataSource;
import xyz.erupt.core.query.EruptQuery;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;
import xyz.erupt.jpa.dao.EruptJpaUtils;
import xyz.erupt.jpa.service.EntityManagerService;

@Repository
public class EruptJpaDao {
    @Resource
    private EntityManagerService entityManagerService;

    public void addEntity(Class<?> eruptClass, Object entity) {
        this.entityManagerService.entityManagerTran(eruptClass, em -> {
            em.persist(entity);
            em.flush();
        });
    }

    public void editEntity(Class<?> eruptClass, Object entity) {
        this.entityManagerService.entityManagerTran(eruptClass, em -> {
            em.merge(entity);
            em.flush();
        });
    }

    public void removeEntity(Class<?> eruptClass, Object entity) {
        this.entityManagerService.entityManagerTran(eruptClass, em -> {
            EruptDataSource eruptDataSource = eruptClass.getAnnotation(EruptDataSource.class);
            if (null == eruptDataSource) {
                em.remove(entity);
            } else {
                em.remove(em.merge(entity));
            }
            em.flush();
        });
    }

    public Page queryEruptList(EruptModel eruptModel, Page page, EruptQuery eruptQuery) {
        String hql = EruptJpaUtils.generateEruptJpaHql(eruptModel, "new map(" + String.join((CharSequence)",", EruptJpaUtils.getEruptColJpaKeys(eruptModel)) + ")", eruptQuery, false);
        String countHql = EruptJpaUtils.generateEruptJpaHql(eruptModel, "count(*)", eruptQuery, true);
        return this.entityManagerService.getEntityManager(eruptModel.getClazz(), entityManager -> {
            Query query = entityManager.createQuery(hql);
            Query countQuery = entityManager.createQuery(countHql);
            Map eruptFieldMap = eruptModel.getEruptFieldMap();
            if (null != eruptQuery.getConditions()) {
                for (Condition condition : eruptQuery.getConditions()) {
                    EruptFieldModel eruptFieldModel = (EruptFieldModel)eruptFieldMap.get(condition.getKey());
                    switch (condition.getExpression()) {
                        case EQ: {
                            countQuery.setParameter(condition.getKey(), EruptUtil.convertObjectType((EruptFieldModel)eruptFieldModel, (Object)condition.getValue()));
                            query.setParameter(condition.getKey(), EruptUtil.convertObjectType((EruptFieldModel)eruptFieldModel, (Object)condition.getValue()));
                            break;
                        }
                        case LIKE: {
                            countQuery.setParameter(condition.getKey(), (Object)("%" + condition.getValue() + "%"));
                            query.setParameter(condition.getKey(), (Object)("%" + condition.getValue() + "%"));
                            break;
                        }
                        case RANGE: {
                            List list = (List)condition.getValue();
                            countQuery.setParameter("l_" + condition.getKey(), EruptUtil.convertObjectType((EruptFieldModel)eruptFieldModel, list.get(0)));
                            countQuery.setParameter("r_" + condition.getKey(), EruptUtil.convertObjectType((EruptFieldModel)eruptFieldModel, list.get(1)));
                            query.setParameter("l_" + condition.getKey(), EruptUtil.convertObjectType((EruptFieldModel)eruptFieldModel, list.get(0)));
                            query.setParameter("r_" + condition.getKey(), EruptUtil.convertObjectType((EruptFieldModel)eruptFieldModel, list.get(1)));
                            break;
                        }
                        case IN: {
                            ArrayList<Object> listIn = new ArrayList<Object>();
                            for (Object o : (List)condition.getValue()) {
                                listIn.add(EruptUtil.convertObjectType((EruptFieldModel)eruptFieldModel, o));
                            }
                            countQuery.setParameter(condition.getKey(), listIn);
                            query.setParameter(condition.getKey(), listIn);
                        }
                    }
                }
            }
            page.setTotal((Long)countQuery.getSingleResult());
            if (page.getTotal() > 0L) {
                page.setList((Collection)query.setMaxResults(page.getPageSize()).setFirstResult((page.getPageIndex() - 1) * page.getPageSize()).getResultList());
            } else {
                page.setList(new ArrayList(0));
            }
            return page;
        });
    }
}

