/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.query.Column;
import xyz.erupt.core.query.EruptQuery;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.IEruptDataService;
import xyz.erupt.core.util.AnnotationUtil;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;
import xyz.erupt.jpa.dao.EruptJpaDao;
import xyz.erupt.jpa.dao.EruptJpaUtils;
import xyz.erupt.jpa.service.EntityManagerService;
import xyz.erupt.jpa.support.JpaSupport;

@Service
public class EruptDataServiceDbImpl
implements IEruptDataService {
    @Resource
    private EruptJpaDao eruptJpaDao;
    @Resource
    private EntityManagerService entityManagerService;
    @Resource
    private JpaSupport jpaSupport;

    public Object findDataById(EruptModel eruptModel, Object id) {
        return this.entityManagerService.getEntityManager(eruptModel.getClazz(), em -> em.find(eruptModel.getClazz(), id));
    }

    public Page queryList(EruptModel eruptModel, Page page, EruptQuery query) {
        return this.eruptJpaDao.queryEruptList(eruptModel, page, query);
    }

    @Transactional
    public void addData(EruptModel eruptModel, Object data) {
        try {
            this.loadSupport(data);
            this.jpaManyToOneConvert(eruptModel, data);
            this.eruptJpaDao.addEntity(eruptModel.getClazz(), data);
        }
        catch (Exception e) {
            this.handlerException(e, eruptModel);
        }
    }

    @Transactional
    public void editData(EruptModel eruptModel, Object data) {
        try {
            this.loadSupport(data);
            this.eruptJpaDao.editEntity(eruptModel.getClazz(), data);
        }
        catch (Exception e) {
            this.handlerException(e, eruptModel);
        }
    }

    private void loadSupport(Object jpaEntity) {
        for (Field field : jpaEntity.getClass().getDeclaredFields()) {
            this.jpaSupport.referencedColumnNameSupport(jpaEntity, field);
        }
    }

    private void handlerException(Exception e, EruptModel eruptModel) {
        e.printStackTrace();
        if (e instanceof DataIntegrityViolationException) {
            if (e.getMessage().contains("ConstraintViolationException")) {
                throw new EruptWebApiRuntimeException(this.gcRepeatHint(eruptModel));
            }
            if (e.getMessage().contains("DataException")) {
                throw new EruptWebApiRuntimeException("\u5185\u5bb9\u8d85\u51fa\u6570\u636e\u5e93\u9650\u5236\u957f\u5ea6\uff01");
            }
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
        throw new EruptWebApiRuntimeException(e.getMessage());
    }

    @Transactional
    public void deleteData(EruptModel eruptModel, Object object) {
        try {
            this.eruptJpaDao.removeEntity(eruptModel.getClazz(), object);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException e) {
            e.printStackTrace();
            throw new EruptWebApiRuntimeException("\u5220\u9664\u5931\u8d25\uff0c\u53ef\u80fd\u5b58\u5728\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u76f4\u63a5\u5220\u9664\uff01");
        }
        catch (Exception e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    private void jpaManyToOneConvert(EruptModel eruptModel, Object object) throws IllegalAccessException {
        for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
            if (fieldModel.getEruptField().edit().type() != EditType.TAB_TABLE_ADD) continue;
            Field field = ReflectUtil.findClassField(object.getClass(), (String)fieldModel.getFieldName());
            field.setAccessible(true);
            Collection collection = (Collection)field.get(object);
            if (null == collection) continue;
            for (Object o : collection) {
                ReflectUtil.findClassField(o.getClass(), (String)EruptCoreService.getErupt((String)fieldModel.getFieldReturnName()).getErupt().primaryKeyCol()).set(o, null);
            }
        }
    }

    private String gcRepeatHint(EruptModel eruptModel) {
        StringBuilder str = new StringBuilder();
        for (UniqueConstraint uniqueConstraint : eruptModel.getClazz().getAnnotation(Table.class).uniqueConstraints()) {
            for (String columnName : uniqueConstraint.columnNames()) {
                EruptFieldModel eruptFieldModel = (EruptFieldModel)eruptModel.getEruptFieldMap().get(columnName);
                if (null == eruptFieldModel) continue;
                str.append(eruptFieldModel.getEruptField().views()[0].title()).append("\u3001");
            }
        }
        String repeatTxt = "\u6570\u636e\u91cd\u590d";
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return str.substring(0, str.length() - 1) + repeatTxt;
        }
        return repeatTxt;
    }

    public Collection<Map<String, Object>> queryColumn(EruptModel eruptModel, List<Column> columns, EruptQuery query) {
        StringBuilder hql = new StringBuilder();
        ArrayList columnStrList = new ArrayList();
        columns.forEach(column -> columnStrList.add(EruptJpaUtils.completeHqlPath(eruptModel.getEruptName(), column.getName()) + " as " + column.getAlias()));
        hql.append("select new map(").append(String.join((CharSequence)", ", columnStrList)).append(") from ").append(eruptModel.getEruptName()).append(" as ").append(eruptModel.getEruptName());
        ReflectUtil.findClassAllFields((Class)eruptModel.getClazz(), field -> {
            if (null != field.getAnnotation(ManyToOne.class) || null != field.getAnnotation(OneToOne.class)) {
                hql.append(" left outer join ").append(eruptModel.getEruptName()).append(".").append(field.getName()).append(" as ").append(field.getName());
            }
        });
        hql.append(" where 1 = 1 ");
        Optional.ofNullable(query.getConditions()).ifPresent(c -> c.forEach(it -> hql.append(" and ").append(it.getKey()).append('=').append(it.getValue())));
        Optional.ofNullable(query.getConditionStrings()).ifPresent(c -> c.forEach(it -> hql.append(" and ").append((String)it)));
        Arrays.stream(eruptModel.getErupt().filter()).map(AnnotationUtil::switchFilterConditionToStr).filter(StringUtils::isNotBlank).forEach(it -> hql.append(" and ").append((String)it));
        if (StringUtils.isNotBlank((CharSequence)query.getOrderBy())) {
            hql.append(" order by ").append(query.getOrderBy());
        }
        return this.entityManagerService.getEntityManager(eruptModel.getClazz(), em -> em.createQuery(hql.toString()).getResultList());
    }

    static {
        DataProcessorManager.register((String)"jpa", EruptDataServiceDbImpl.class);
    }
}

