/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.config.Comment;
import xyz.erupt.jpa.service.EntityManagerService;

@Component
public class EruptDao {
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private EntityManagerService entityManagerService;
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String NEW_MAP = "new map(";
    private static final String AND = " and ";
    private static final String AS = " as ";
    private static final String EQU = " = ";
    private static final String WHERE = " where ";

    public <T> T merge(T t) {
        return (T)this.entityManager.merge(t);
    }

    public <T> T mergeAndFlush(T t) {
        try {
            T t2 = this.merge(t);
            return t2;
        }
        finally {
            this.flush();
        }
    }

    public void flush() {
        this.entityManager.flush();
    }

    public void delete(Object obj) {
        this.entityManager.remove(obj);
    }

    public void persist(Object obj) {
        this.entityManager.persist(obj);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Comment(value="\u6839\u636e\u6570\u636e\u6e90\u540d\u79f0\u83b7\u53d6 EntityManager  \u6ce8\u610f\uff1a\u5fc5\u987b\u624b\u52a8\u6267\u884c entityManager.close() \u65b9\u6cd5")
    public EntityManager getEntityManager(String name) {
        return this.entityManagerService.findEntityManager(name);
    }

    public <T> T persistIfNotExist(Class<T> eruptClass, Object obj, String field, final String val) throws NonUniqueResultException {
        Object t = this.queryEntity(obj.getClass(), field + EQU + " :val", (Map<String, Object>)new HashMap<String, Object>(1){
            {
                super(initialCapacity);
                this.put("val", val);
            }
        });
        if (null == t) {
            this.entityManager.persist(obj);
            this.entityManager.flush();
            return (T)obj;
        }
        return (T)t;
    }

    public List<Map<String, Object>> queryMapList(Class<?> eruptClass, String expr, Map<String, Object> param, String ... cols) {
        return this.simpleQuery(eruptClass, true, expr, param, cols).getResultList();
    }

    public List<Object[]> queryObjectList(Class<?> eruptClass, String expr, Map<String, Object> param, String ... cols) {
        return this.simpleQuery(eruptClass, false, expr, param, cols).getResultList();
    }

    public <T> List<T> queryEntityList(Class<T> eruptClass, String expr, Map<String, Object> param) {
        return this.simpleQuery(eruptClass, false, expr, param, new String[0]).getResultList();
    }

    public <T> List<T> queryEntityList(Class<T> eruptClass, String expr) {
        return this.queryEntityList(eruptClass, expr, null);
    }

    public <T> List<T> queryEntityList(Class<T> eruptClass) {
        return this.queryEntityList(eruptClass, null);
    }

    public Map<String, Object> queryMap(Class<?> eruptClass, String expr, Map<String, Object> param, String ... cols) throws NonUniqueResultException {
        try {
            return (Map)this.simpleQuery(eruptClass, true, expr, param, cols).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Object[] queryObject(Class<?> eruptClass, String expr, Map<String, Object> param, String ... cols) throws NonUniqueResultException {
        try {
            return (Object[])this.simpleQuery(eruptClass, false, expr, param, cols).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public <T> T queryEntity(Class<T> eruptClass, String expr, Map<String, Object> param) throws NonUniqueResultException {
        try {
            return (T)this.simpleQuery(eruptClass, false, expr, param, new String[0]).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public <T> T queryEntity(Class<T> eruptClass, String expr) {
        return this.queryEntity(eruptClass, expr, null);
    }

    public <T> T queryEntity(Class<T> eruptClass) {
        return this.queryEntity(eruptClass, null);
    }

    private Query simpleQuery(Class<?> eruptClass, boolean isMap, String expr, Map<String, Object> paramMap, String ... cols) {
        StringBuilder sb = new StringBuilder();
        if (cols.length > 0) {
            int i;
            sb.append(SELECT);
            if (isMap) {
                sb.append(NEW_MAP);
                for (i = 0; i < cols.length; ++i) {
                    sb.append(cols[i]).append(AS).append(cols[i]).append(i == cols.length - 1 ? "" : ",");
                }
                sb.append(")");
            } else {
                for (i = 0; i < cols.length; ++i) {
                    sb.append(cols[i]).append(i == cols.length - 1 ? "" : ",");
                }
            }
        }
        expr = StringUtils.isBlank((CharSequence)expr) ? "" : WHERE + expr;
        Query query = this.entityManager.createQuery(sb + FROM + eruptClass.getSimpleName() + expr);
        Optional.ofNullable(paramMap).ifPresent(map -> map.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1)));
        return query;
    }
}

