/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.sub_erupt.Filter;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.query.Column;
import xyz.erupt.core.query.EruptQuery;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.service.IEruptDataService;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.core.util.TypeUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.core.view.Page;
import xyz.erupt.jpa.dao.EruptJpaDao;
import xyz.erupt.jpa.dao.EruptJpaUtils;
import xyz.erupt.jpa.service.EntityManagerService;
import xyz.erupt.jpa.support.JpaSupport;

@Service
public class EruptDataServiceDbImpl
implements IEruptDataService {
    @Resource
    private EruptJpaDao eruptJpaDao;
    @Resource
    private EntityManagerService entityManagerService;
    @Resource
    private JpaSupport jpaSupport;

    public Object findDataById(EruptModel eruptModel, Object id) {
        return this.entityManagerService.getEntityManager(eruptModel.getClazz(), em -> em.find(eruptModel.getClazz(), id));
    }

    public Page queryList(EruptModel eruptModel, Page page, EruptQuery query) {
        return this.eruptJpaDao.queryEruptList(eruptModel, page, query);
    }

    @Transactional
    public void addData(EruptModel eruptModel, Object data) {
        try {
            this.loadSupport(data);
            this.jpaManyToOneConvert(eruptModel, data);
            this.eruptJpaDao.addEntity(eruptModel.getClazz(), data);
        }
        catch (Exception e) {
            this.handlerException(e, eruptModel);
        }
    }

    public void batchAddData(EruptModel eruptModel, List<?> objectList) {
        try {
            for (Object data : objectList) {
                this.loadSupport(data);
                this.jpaManyToOneConvert(eruptModel, data);
            }
            this.entityManagerService.entityManagerTran(eruptModel.getClazz(), em -> {
                for (int i = 0; i < objectList.size(); ++i) {
                    Object entity = objectList.get(i);
                    em.persist(entity);
                    if (i % 500 != 0) continue;
                    em.flush();
                }
            });
        }
        catch (Exception e) {
            this.handlerException(e, eruptModel);
        }
    }

    @Transactional
    public void editData(EruptModel eruptModel, Object data) {
        try {
            this.loadSupport(data);
            this.eruptJpaDao.editEntity(eruptModel.getClazz(), data);
        }
        catch (Exception e) {
            this.handlerException(e, eruptModel);
        }
    }

    private void loadSupport(Object jpaEntity) {
        for (Field field : jpaEntity.getClass().getDeclaredFields()) {
            this.jpaSupport.referencedColumnNameSupport(jpaEntity, field);
        }
    }

    private void handlerException(Exception e, EruptModel eruptModel) {
        e.printStackTrace();
        if (e instanceof DataIntegrityViolationException) {
            if (e.getMessage().contains("ConstraintViolationException")) {
                throw new EruptWebApiRuntimeException(this.gcRepeatHint(eruptModel));
            }
            if (e.getMessage().contains("DataException")) {
                throw new EruptWebApiRuntimeException(I18nTranslate.$translate((String)"erupt.data.limit_length"));
            }
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
        throw new EruptWebApiRuntimeException(e.getMessage());
    }

    @Transactional
    public void deleteData(EruptModel eruptModel, Object object) {
        try {
            this.eruptJpaDao.removeEntity(eruptModel.getClazz(), object);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException e) {
            e.printStackTrace();
            throw new EruptWebApiRuntimeException(I18nTranslate.$translate((String)"erupt.data.delete_fail_may_be_associated_data"));
        }
        catch (Exception e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    private void jpaManyToOneConvert(EruptModel eruptModel, Object object) throws IllegalAccessException {
        for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
            if (fieldModel.getEruptField().edit().type() != EditType.TAB_TABLE_ADD) continue;
            Field field = ReflectUtil.findClassField(object.getClass(), (String)fieldModel.getFieldName());
            field.setAccessible(true);
            Collection collection = (Collection)field.get(object);
            if (null == collection) continue;
            for (Object o : collection) {
                ReflectUtil.findClassField(o.getClass(), (String)EruptCoreService.getErupt((String)fieldModel.getFieldReturnName()).getErupt().primaryKeyCol()).set(o, null);
            }
        }
    }

    private String gcRepeatHint(EruptModel eruptModel) {
        StringBuilder str = new StringBuilder();
        for (UniqueConstraint uniqueConstraint : eruptModel.getClazz().getAnnotation(Table.class).uniqueConstraints()) {
            for (String columnName : uniqueConstraint.columnNames()) {
                EruptFieldModel eruptFieldModel = (EruptFieldModel)eruptModel.getEruptFieldMap().get(columnName);
                if (null == eruptFieldModel) continue;
                str.append(eruptFieldModel.getEruptField().views()[0].title()).append("\u3001");
            }
        }
        String repeatTxt = I18nTranslate.$translate((String)"erupt.data.data_duplication");
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return str.substring(0, str.length() - 1) + " " + repeatTxt;
        }
        return repeatTxt;
    }

    public Collection<Map<String, Object>> queryColumn(EruptModel eruptModel, List<Column> columns, EruptQuery query) {
        StringBuilder hql = new StringBuilder();
        ArrayList columnStrList = new ArrayList();
        columns.forEach(column -> columnStrList.add(EruptJpaUtils.completeHqlPath(eruptModel.getEruptName(), column.getName()) + " as " + column.getAlias()));
        hql.append("select new map(").append(String.join((CharSequence)", ", columnStrList)).append(") from ").append(eruptModel.getEruptName()).append(" as ").append(eruptModel.getEruptName());
        ReflectUtil.findClassAllFields((Class)eruptModel.getClazz(), field -> {
            if (null != field.getAnnotation(ManyToOne.class) || null != field.getAnnotation(OneToOne.class)) {
                hql.append(" left outer join ").append(eruptModel.getEruptName()).append(".").append(field.getName()).append(" as ").append(field.getName());
            }
        });
        hql.append(" where 1 = 1 ");
        Optional.ofNullable(query.getConditions()).ifPresent(c -> c.forEach(it -> {
            hql.append(" and ").append(it.getKey()).append('=');
            if (TypeUtil.isNumber((Object)it.getValue())) {
                hql.append(it.getValue());
            } else {
                hql.append("'").append(it.getValue()).append("'");
            }
        }));
        Optional.ofNullable(query.getConditionStrings()).ifPresent(c -> c.forEach(it -> hql.append(" and ").append((String)it)));
        Arrays.stream(eruptModel.getErupt().filter()).map(Filter::value).filter(StringUtils::isNotBlank).forEach(it -> hql.append(" and ").append((String)it));
        if (StringUtils.isNotBlank((CharSequence)query.getOrderBy())) {
            hql.append(" order by ").append(query.getOrderBy());
        }
        return this.entityManagerService.getEntityManager(eruptModel.getClazz(), em -> em.createQuery(hql.toString()).getResultList());
    }

    static {
        DataProcessorManager.register((String)"jpa", EruptDataServiceDbImpl.class);
    }
}

