/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.jpa.support;

import java.lang.reflect.Field;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.JoinColumn;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.core.annotation.EruptDataSource;
import xyz.erupt.core.util.ReflectUtil;
import xyz.erupt.jpa.dao.EruptDao;

@Component
public class JpaSupport {
    @Resource
    private EruptDao eruptDao;

    public void referencedColumnNameSupport(Object obj, Field field) {
        JoinColumn joinColumn;
        EruptField eruptField = field.getAnnotation(EruptField.class);
        if (null != eruptField && null != (joinColumn = field.getAnnotation(JoinColumn.class)) && !"".equals(joinColumn.referencedColumnName())) {
            String id;
            if (eruptField.edit().type() == EditType.REFERENCE_TREE) {
                id = eruptField.edit().referenceTreeType().id();
            } else if (eruptField.edit().type() == EditType.REFERENCE_TABLE) {
                id = eruptField.edit().referenceTableType().id();
            } else {
                return;
            }
            field.setAccessible(true);
            Object refObject = field.get(obj);
            if (null != refObject) {
                Field idField = ReflectUtil.findClassField(refObject.getClass(), (String)id);
                idField.setAccessible(true);
                EntityManager em = this.eruptDao.getEntityManager();
                EruptDataSource eruptDataSource = refObject.getClass().getAnnotation(EruptDataSource.class);
                if (eruptDataSource != null) {
                    em = this.eruptDao.getEntityManager(eruptDataSource.value());
                }
                Object result = em.createQuery("from " + refObject.getClass().getSimpleName() + " I where I.id = :id").setParameter("id", idField.get(refObject)).getSingleResult();
                em.close();
                field.set(obj, result);
            }
        }
    }
}

