/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videocontroller.component;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import xyz.doikki.videocontroller.R;
import xyz.doikki.videoplayer.controller.ControlWrapper;
import xyz.doikki.videoplayer.controller.IControlComponent;
import xyz.doikki.videoplayer.util.PlayerUtils;

public class LiveControlView
extends FrameLayout
implements IControlComponent,
View.OnClickListener {
    private ControlWrapper mControlWrapper;
    private final ImageView mFullScreen;
    private final LinearLayout mBottomContainer;
    private final ImageView mPlayButton;

    public LiveControlView(@NonNull Context context) {
        super(context);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_live_control_view, (ViewGroup)this, true);
        this.mFullScreen = (ImageView)this.findViewById(R.id.fullscreen);
        this.mFullScreen.setOnClickListener((View.OnClickListener)this);
        this.mBottomContainer = (LinearLayout)this.findViewById(R.id.bottom_container);
        this.mPlayButton = (ImageView)this.findViewById(R.id.iv_play);
        this.mPlayButton.setOnClickListener((View.OnClickListener)this);
        ImageView refresh = (ImageView)this.findViewById(R.id.iv_refresh);
        refresh.setOnClickListener((View.OnClickListener)this);
    }

    public LiveControlView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_live_control_view, (ViewGroup)this, true);
        this.mFullScreen = (ImageView)this.findViewById(R.id.fullscreen);
        this.mFullScreen.setOnClickListener((View.OnClickListener)this);
        this.mBottomContainer = (LinearLayout)this.findViewById(R.id.bottom_container);
        this.mPlayButton = (ImageView)this.findViewById(R.id.iv_play);
        this.mPlayButton.setOnClickListener((View.OnClickListener)this);
        ImageView refresh = (ImageView)this.findViewById(R.id.iv_refresh);
        refresh.setOnClickListener((View.OnClickListener)this);
    }

    public LiveControlView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_live_control_view, (ViewGroup)this, true);
        this.mFullScreen = (ImageView)this.findViewById(R.id.fullscreen);
        this.mFullScreen.setOnClickListener((View.OnClickListener)this);
        this.mBottomContainer = (LinearLayout)this.findViewById(R.id.bottom_container);
        this.mPlayButton = (ImageView)this.findViewById(R.id.iv_play);
        this.mPlayButton.setOnClickListener((View.OnClickListener)this);
        ImageView refresh = (ImageView)this.findViewById(R.id.iv_refresh);
        refresh.setOnClickListener((View.OnClickListener)this);
    }

    public void attach(@NonNull ControlWrapper controlWrapper) {
        this.mControlWrapper = controlWrapper;
    }

    public View getView() {
        return this;
    }

    public void onVisibilityChanged(boolean isVisible, Animation anim) {
        if (isVisible) {
            if (this.getVisibility() == 8) {
                this.setVisibility(0);
                if (anim != null) {
                    this.startAnimation(anim);
                }
            }
        } else if (this.getVisibility() == 0) {
            this.setVisibility(8);
            if (anim != null) {
                this.startAnimation(anim);
            }
        }
    }

    public void onPlayStateChanged(int playState) {
        switch (playState) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                this.setVisibility(8);
                break;
            }
            case 3: {
                this.mPlayButton.setSelected(true);
                break;
            }
            case 4: {
                this.mPlayButton.setSelected(false);
                break;
            }
            case 6: 
            case 7: {
                this.mPlayButton.setSelected(this.mControlWrapper.isPlaying());
            }
        }
    }

    public void onPlayerStateChanged(int playerState) {
        switch (playerState) {
            case 10: {
                this.mFullScreen.setSelected(false);
                break;
            }
            case 11: {
                this.mFullScreen.setSelected(true);
            }
        }
        Activity activity = PlayerUtils.scanForActivity((Context)this.getContext());
        if (activity != null && this.mControlWrapper.hasCutout()) {
            int orientation = activity.getRequestedOrientation();
            int cutoutHeight = this.mControlWrapper.getCutoutHeight();
            if (orientation == 1) {
                this.mBottomContainer.setPadding(0, 0, 0, 0);
            } else if (orientation == 0) {
                this.mBottomContainer.setPadding(cutoutHeight, 0, 0, 0);
            } else if (orientation == 8) {
                this.mBottomContainer.setPadding(0, 0, cutoutHeight, 0);
            }
        }
    }

    public void setProgress(int duration, int position) {
    }

    public void onLockStateChanged(boolean isLocked) {
        this.onVisibilityChanged(!isLocked, null);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.fullscreen) {
            this.toggleFullScreen();
        } else if (id2 == R.id.iv_play) {
            this.mControlWrapper.togglePlay();
        } else if (id2 == R.id.iv_refresh) {
            this.mControlWrapper.replay(true);
        }
    }

    private void toggleFullScreen() {
        Activity activity = PlayerUtils.scanForActivity((Context)this.getContext());
        this.mControlWrapper.toggleFullScreen(activity);
    }
}

