/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videocontroller.component;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import xyz.doikki.videocontroller.R;
import xyz.doikki.videoplayer.controller.ControlWrapper;
import xyz.doikki.videoplayer.controller.IControlComponent;

public class ErrorView
extends LinearLayout
implements IControlComponent {
    private float mDownX;
    private float mDownY;
    private ControlWrapper mControlWrapper;

    public ErrorView(Context context) {
        this(context, null);
    }

    public ErrorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_error_view, (ViewGroup)this, true);
        this.findViewById(R.id.status_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ErrorView.this.setVisibility(8);
                ErrorView.this.mControlWrapper.replay(false);
            }
        });
        this.setClickable(true);
    }

    public ErrorView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_error_view, (ViewGroup)this, true);
        this.findViewById(R.id.status_btn).setOnClickListener(new /* invalid duplicate definition of identical inner class */);
        this.setClickable(true);
    }

    public void attach(@NonNull ControlWrapper controlWrapper) {
        this.mControlWrapper = controlWrapper;
    }

    public View getView() {
        return this;
    }

    public void onVisibilityChanged(boolean isVisible, Animation anim) {
    }

    public void onPlayStateChanged(int playState) {
        if (playState == -1) {
            this.bringToFront();
            this.setVisibility(0);
        } else if (playState == 0) {
            this.setVisibility(8);
        }
    }

    public void onPlayerStateChanged(int playerState) {
    }

    public void setProgress(int duration, int position) {
    }

    public void onLockStateChanged(boolean isLock) {
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mDownX = ev.getX();
                this.mDownY = ev.getY();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float absDeltaX = Math.abs(ev.getX() - this.mDownX);
                float absDeltaY = Math.abs(ev.getY() - this.mDownY);
                if (!(absDeltaX > (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop()) && !(absDeltaY > (float)ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop())) break;
                this.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        return super.dispatchTouchEvent(ev);
    }
}

