/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videocontroller.component;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import xyz.doikki.videocontroller.R;
import xyz.doikki.videoplayer.controller.ControlWrapper;
import xyz.doikki.videoplayer.controller.IControlComponent;
import xyz.doikki.videoplayer.util.PlayerUtils;

public class CompleteView
extends FrameLayout
implements IControlComponent {
    private ControlWrapper mControlWrapper;
    private final ImageView mStopFullscreen;

    public CompleteView(@NonNull Context context) {
        super(context);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_complete_view, (ViewGroup)this, true);
        this.findViewById(R.id.iv_replay).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CompleteView.this.mControlWrapper.replay(true);
            }
        });
        this.mStopFullscreen = (ImageView)this.findViewById(R.id.stop_fullscreen);
        this.mStopFullscreen.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Activity activity;
                if (CompleteView.this.mControlWrapper.isFullScreen() && (activity = PlayerUtils.scanForActivity((Context)CompleteView.this.getContext())) != null && !activity.isFinishing()) {
                    activity.setRequestedOrientation(1);
                    CompleteView.this.mControlWrapper.stopFullScreen();
                }
            }
        });
        this.setClickable(true);
    }

    public CompleteView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_complete_view, (ViewGroup)this, true);
        this.findViewById(R.id.iv_replay).setOnClickListener(new /* invalid duplicate definition of identical inner class */);
        this.mStopFullscreen = (ImageView)this.findViewById(R.id.stop_fullscreen);
        this.mStopFullscreen.setOnClickListener(new /* invalid duplicate definition of identical inner class */);
        this.setClickable(true);
    }

    public CompleteView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_complete_view, (ViewGroup)this, true);
        this.findViewById(R.id.iv_replay).setOnClickListener(new /* invalid duplicate definition of identical inner class */);
        this.mStopFullscreen = (ImageView)this.findViewById(R.id.stop_fullscreen);
        this.mStopFullscreen.setOnClickListener(new /* invalid duplicate definition of identical inner class */);
        this.setClickable(true);
    }

    public void attach(@NonNull ControlWrapper controlWrapper) {
        this.mControlWrapper = controlWrapper;
    }

    public View getView() {
        return this;
    }

    public void onVisibilityChanged(boolean isVisible, Animation anim) {
    }

    public void onPlayStateChanged(int playState) {
        if (playState == 5) {
            this.setVisibility(0);
            this.mStopFullscreen.setVisibility(this.mControlWrapper.isFullScreen() ? 0 : 8);
            this.bringToFront();
        } else {
            this.setVisibility(8);
        }
    }

    public void onPlayerStateChanged(int playerState) {
        if (playerState == 11) {
            this.mStopFullscreen.setVisibility(0);
        } else if (playerState == 10) {
            this.mStopFullscreen.setVisibility(8);
        }
        Activity activity = PlayerUtils.scanForActivity((Context)this.getContext());
        if (activity != null && this.mControlWrapper.hasCutout()) {
            int orientation = activity.getRequestedOrientation();
            int cutoutHeight = this.mControlWrapper.getCutoutHeight();
            FrameLayout.LayoutParams sflp = (FrameLayout.LayoutParams)this.mStopFullscreen.getLayoutParams();
            if (orientation == 1) {
                sflp.setMargins(0, 0, 0, 0);
            } else if (orientation == 0) {
                sflp.setMargins(cutoutHeight, 0, 0, 0);
            } else if (orientation == 8) {
                sflp.setMargins(0, 0, 0, 0);
            }
        }
    }

    public void setProgress(int duration, int position) {
    }

    public void onLockStateChanged(boolean isLock) {
    }
}

