/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videocontroller.component;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import xyz.doikki.videocontroller.R;
import xyz.doikki.videoplayer.controller.ControlWrapper;
import xyz.doikki.videoplayer.controller.IGestureComponent;
import xyz.doikki.videoplayer.util.PlayerUtils;

public class GestureView
extends FrameLayout
implements IGestureComponent {
    private ControlWrapper mControlWrapper;
    private ImageView mIcon;
    private ProgressBar mProgressPercent;
    private TextView mTextPercent;
    private LinearLayout mCenterContainer;

    public GestureView(@NonNull Context context) {
        super(context);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_gesture_control_view, (ViewGroup)this, true);
        this.mIcon = (ImageView)this.findViewById(R.id.iv_icon);
        this.mProgressPercent = (ProgressBar)this.findViewById(R.id.pro_percent);
        this.mTextPercent = (TextView)this.findViewById(R.id.tv_percent);
        this.mCenterContainer = (LinearLayout)this.findViewById(R.id.center_container);
    }

    public GestureView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_gesture_control_view, (ViewGroup)this, true);
        this.mIcon = (ImageView)this.findViewById(R.id.iv_icon);
        this.mProgressPercent = (ProgressBar)this.findViewById(R.id.pro_percent);
        this.mTextPercent = (TextView)this.findViewById(R.id.tv_percent);
        this.mCenterContainer = (LinearLayout)this.findViewById(R.id.center_container);
    }

    public GestureView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_gesture_control_view, (ViewGroup)this, true);
        this.mIcon = (ImageView)this.findViewById(R.id.iv_icon);
        this.mProgressPercent = (ProgressBar)this.findViewById(R.id.pro_percent);
        this.mTextPercent = (TextView)this.findViewById(R.id.tv_percent);
        this.mCenterContainer = (LinearLayout)this.findViewById(R.id.center_container);
    }

    public void attach(@NonNull ControlWrapper controlWrapper) {
        this.mControlWrapper = controlWrapper;
    }

    public View getView() {
        return this;
    }

    public void onVisibilityChanged(boolean isVisible, Animation anim) {
    }

    public void onPlayerStateChanged(int playerState) {
    }

    public void onStartSlide() {
        this.mControlWrapper.hide();
        this.mCenterContainer.setVisibility(0);
        this.mCenterContainer.setAlpha(1.0f);
    }

    public void onStopSlide() {
        this.mCenterContainer.animate().alpha(0.0f).setDuration(300L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                GestureView.this.mCenterContainer.setVisibility(8);
            }
        }).start();
    }

    public void onPositionChange(int slidePosition, int currentPosition, int duration) {
        this.mProgressPercent.setVisibility(8);
        if (slidePosition > currentPosition) {
            this.mIcon.setImageResource(R.drawable.dkplayer_ic_action_fast_forward);
        } else {
            this.mIcon.setImageResource(R.drawable.dkplayer_ic_action_fast_rewind);
        }
        this.mTextPercent.setText((CharSequence)String.format("%s/%s", PlayerUtils.stringForTime((int)slidePosition), PlayerUtils.stringForTime((int)duration)));
    }

    public void onBrightnessChange(int percent) {
        this.mProgressPercent.setVisibility(0);
        this.mIcon.setImageResource(R.drawable.dkplayer_ic_action_brightness);
        this.mTextPercent.setText((CharSequence)(percent + "%"));
        this.mProgressPercent.setProgress(percent);
    }

    public void onVolumeChange(int percent) {
        this.mProgressPercent.setVisibility(0);
        if (percent <= 0) {
            this.mIcon.setImageResource(R.drawable.dkplayer_ic_action_volume_off);
        } else {
            this.mIcon.setImageResource(R.drawable.dkplayer_ic_action_volume_up);
        }
        this.mTextPercent.setText((CharSequence)(percent + "%"));
        this.mProgressPercent.setProgress(percent);
    }

    public void onPlayStateChanged(int playState) {
        if (playState == 0 || playState == 8 || playState == 1 || playState == 2 || playState == -1 || playState == 5) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
        }
    }

    public void setProgress(int duration, int position) {
    }

    public void onLockStateChanged(boolean isLock) {
    }
}

