/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videocontroller;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import xyz.doikki.videocontroller.R;
import xyz.doikki.videocontroller.component.CompleteView;
import xyz.doikki.videocontroller.component.ErrorView;
import xyz.doikki.videocontroller.component.GestureView;
import xyz.doikki.videocontroller.component.LiveControlView;
import xyz.doikki.videocontroller.component.PrepareView;
import xyz.doikki.videocontroller.component.TitleView;
import xyz.doikki.videocontroller.component.VodControlView;
import xyz.doikki.videoplayer.controller.GestureVideoController;
import xyz.doikki.videoplayer.controller.IControlComponent;
import xyz.doikki.videoplayer.util.PlayerUtils;

public class StandardVideoController
extends GestureVideoController
implements View.OnClickListener {
    protected ImageView mLockButton;
    protected ProgressBar mLoadingProgress;

    public StandardVideoController(@NonNull Context context) {
        this(context, null);
    }

    public StandardVideoController(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StandardVideoController(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected int getLayoutId() {
        return R.layout.dkplayer_layout_standard_controller;
    }

    protected void initView() {
        super.initView();
        this.mLockButton = (ImageView)this.findViewById(R.id.lock);
        this.mLockButton.setOnClickListener((View.OnClickListener)this);
        this.mLoadingProgress = (ProgressBar)this.findViewById(R.id.loading);
    }

    public void addDefaultControlComponent(String title, boolean isLive) {
        CompleteView completeView = new CompleteView(this.getContext());
        ErrorView errorView = new ErrorView(this.getContext());
        PrepareView prepareView = new PrepareView(this.getContext());
        prepareView.setClickStart();
        TitleView titleView = new TitleView(this.getContext());
        titleView.setTitle(title);
        this.addControlComponent(new IControlComponent[]{completeView, errorView, prepareView, titleView});
        if (isLive) {
            this.addControlComponent(new IControlComponent[]{new LiveControlView(this.getContext())});
        } else {
            this.addControlComponent(new IControlComponent[]{new VodControlView(this.getContext())});
        }
        this.addControlComponent(new IControlComponent[]{new GestureView(this.getContext())});
        this.setCanChangePosition(!isLive);
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.lock) {
            this.mControlWrapper.toggleLockState();
        }
    }

    protected void onLockStateChanged(boolean isLocked) {
        if (isLocked) {
            this.mLockButton.setSelected(true);
            Toast.makeText((Context)this.getContext(), (int)R.string.dkplayer_locked, (int)0).show();
        } else {
            this.mLockButton.setSelected(false);
            Toast.makeText((Context)this.getContext(), (int)R.string.dkplayer_unlocked, (int)0).show();
        }
    }

    protected void onVisibilityChanged(boolean isVisible, Animation anim) {
        if (this.mControlWrapper.isFullScreen()) {
            if (isVisible) {
                if (this.mLockButton.getVisibility() == 8) {
                    this.mLockButton.setVisibility(0);
                    if (anim != null) {
                        this.mLockButton.startAnimation(anim);
                    }
                }
            } else {
                this.mLockButton.setVisibility(8);
                if (anim != null) {
                    this.mLockButton.startAnimation(anim);
                }
            }
        }
    }

    protected void onPlayerStateChanged(int playerState) {
        super.onPlayerStateChanged(playerState);
        switch (playerState) {
            case 10: {
                this.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.mLockButton.setVisibility(8);
                break;
            }
            case 11: {
                if (this.isShowing()) {
                    this.mLockButton.setVisibility(0);
                    break;
                }
                this.mLockButton.setVisibility(8);
            }
        }
        if (this.mActivity != null && this.hasCutout()) {
            int orientation = this.mActivity.getRequestedOrientation();
            int dp24 = PlayerUtils.dp2px((Context)this.getContext(), (float)24.0f);
            int cutoutHeight = this.getCutoutHeight();
            if (orientation == 1) {
                FrameLayout.LayoutParams lblp = (FrameLayout.LayoutParams)this.mLockButton.getLayoutParams();
                lblp.setMargins(dp24, 0, dp24, 0);
            } else if (orientation == 0) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mLockButton.getLayoutParams();
                layoutParams.setMargins(dp24 + cutoutHeight, 0, dp24 + cutoutHeight, 0);
            } else if (orientation == 8) {
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mLockButton.getLayoutParams();
                layoutParams.setMargins(dp24, 0, dp24, 0);
            }
        }
    }

    protected void onPlayStateChanged(int playState) {
        super.onPlayStateChanged(playState);
        switch (playState) {
            case 0: {
                this.mLockButton.setSelected(false);
                this.mLoadingProgress.setVisibility(8);
                break;
            }
            case -1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                this.mLoadingProgress.setVisibility(8);
                break;
            }
            case 1: 
            case 6: {
                this.mLoadingProgress.setVisibility(0);
                break;
            }
            case 5: {
                this.mLoadingProgress.setVisibility(8);
                this.mLockButton.setVisibility(8);
                this.mLockButton.setSelected(false);
            }
        }
    }

    public boolean onBackPressed() {
        if (this.isLocked()) {
            this.show();
            Toast.makeText((Context)this.getContext(), (int)R.string.dkplayer_lock_tip, (int)0).show();
            return true;
        }
        if (this.mControlWrapper.isFullScreen()) {
            return this.stopFullScreen();
        }
        return super.onBackPressed();
    }
}

