/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videocontroller.component;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.dueeeke.videocontroller.R;
import com.dueeeke.videoplayer.controller.ControlWrapper;
import com.dueeeke.videoplayer.controller.IControlComponent;
import com.dueeeke.videoplayer.util.PlayerUtils;

public class TitleView
extends FrameLayout
implements IControlComponent {
    private ControlWrapper mControlWrapper;
    private LinearLayout mTitleContainer;
    private TextView mTitle;
    private TextView mSysTime;
    private BatteryReceiver mBatteryReceiver;
    private boolean mIsRegister;

    public TitleView(@NonNull Context context) {
        super(context);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_title_view, (ViewGroup)this, true);
        this.mTitleContainer = (LinearLayout)this.findViewById(R.id.title_container);
        ImageView back = (ImageView)this.findViewById(R.id.back);
        back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Activity activity = PlayerUtils.scanForActivity((Context)TitleView.this.getContext());
                if (activity != null && TitleView.this.mControlWrapper.isFullScreen()) {
                    activity.setRequestedOrientation(1);
                    TitleView.this.mControlWrapper.stopFullScreen();
                }
            }
        });
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mSysTime = (TextView)this.findViewById(R.id.sys_time);
        ImageView batteryLevel = (ImageView)this.findViewById(R.id.iv_battery);
        this.mBatteryReceiver = new BatteryReceiver(batteryLevel);
    }

    public TitleView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_title_view, (ViewGroup)this, true);
        this.mTitleContainer = (LinearLayout)this.findViewById(R.id.title_container);
        ImageView back = (ImageView)this.findViewById(R.id.back);
        back.setOnClickListener(new /* invalid duplicate definition of identical inner class */);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mSysTime = (TextView)this.findViewById(R.id.sys_time);
        ImageView batteryLevel = (ImageView)this.findViewById(R.id.iv_battery);
        this.mBatteryReceiver = new BatteryReceiver(batteryLevel);
    }

    public TitleView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVisibility(8);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_title_view, (ViewGroup)this, true);
        this.mTitleContainer = (LinearLayout)this.findViewById(R.id.title_container);
        ImageView back = (ImageView)this.findViewById(R.id.back);
        back.setOnClickListener(new /* invalid duplicate definition of identical inner class */);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mSysTime = (TextView)this.findViewById(R.id.sys_time);
        ImageView batteryLevel = (ImageView)this.findViewById(R.id.iv_battery);
        this.mBatteryReceiver = new BatteryReceiver(batteryLevel);
    }

    public void setTitle(String title) {
        this.mTitle.setText((CharSequence)title);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mIsRegister) {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.mBatteryReceiver);
            this.mIsRegister = false;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mIsRegister) {
            this.getContext().registerReceiver((BroadcastReceiver)this.mBatteryReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            this.mIsRegister = true;
        }
    }

    public void attach(@NonNull ControlWrapper controlWrapper) {
        this.mControlWrapper = controlWrapper;
    }

    public View getView() {
        return this;
    }

    public void onVisibilityChanged(boolean isVisible, Animation anim) {
        if (!this.mControlWrapper.isFullScreen()) {
            return;
        }
        if (isVisible) {
            if (this.getVisibility() == 8) {
                this.mSysTime.setText((CharSequence)PlayerUtils.getCurrentSystemTime());
                this.setVisibility(0);
                if (anim != null) {
                    this.startAnimation(anim);
                }
            }
        } else if (this.getVisibility() == 0) {
            this.setVisibility(8);
            if (anim != null) {
                this.startAnimation(anim);
            }
        }
    }

    public void onPlayStateChanged(int playState) {
        switch (playState) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                this.setVisibility(8);
            }
        }
    }

    public void onPlayerStateChanged(int playerState) {
        if (playerState == 11) {
            if (this.mControlWrapper.isShowing() && !this.mControlWrapper.isLocked()) {
                this.setVisibility(0);
                this.mSysTime.setText((CharSequence)PlayerUtils.getCurrentSystemTime());
            }
            this.mTitle.setSelected(true);
        } else {
            this.setVisibility(8);
            this.mTitle.setSelected(false);
        }
        Activity activity = PlayerUtils.scanForActivity((Context)this.getContext());
        if (activity != null && this.mControlWrapper.hasCutout()) {
            int orientation = activity.getRequestedOrientation();
            int cutoutHeight = this.mControlWrapper.getCutoutHeight();
            if (orientation == 1) {
                this.mTitleContainer.setPadding(0, 0, 0, 0);
            } else if (orientation == 0) {
                this.mTitleContainer.setPadding(cutoutHeight, 0, 0, 0);
            } else if (orientation == 8) {
                this.mTitleContainer.setPadding(0, 0, cutoutHeight, 0);
            }
        }
    }

    public void setProgress(int duration, int position) {
    }

    public void onLockStateChanged(boolean isLocked) {
        if (isLocked) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
            this.mSysTime.setText((CharSequence)PlayerUtils.getCurrentSystemTime());
        }
    }

    private static class BatteryReceiver
    extends BroadcastReceiver {
        private ImageView pow;

        public BatteryReceiver(ImageView pow) {
            this.pow = pow;
        }

        public void onReceive(Context context, Intent intent) {
            Bundle extras = intent.getExtras();
            if (extras == null) {
                return;
            }
            int current = extras.getInt("level");
            int total = extras.getInt("scale");
            int percent = current * 100 / total;
            this.pow.getDrawable().setLevel(percent);
        }
    }
}

