/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videocontroller.component;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.dueeeke.videocontroller.R;
import com.dueeeke.videoplayer.controller.ControlWrapper;
import com.dueeeke.videoplayer.controller.IControlComponent;
import com.dueeeke.videoplayer.player.VideoViewManager;

public class PrepareView
extends FrameLayout
implements IControlComponent {
    private ControlWrapper mControlWrapper;
    private ImageView mThumb;
    private ImageView mStartPlay;
    private ProgressBar mLoading;
    private FrameLayout mNetWarning;

    public PrepareView(@NonNull Context context) {
        super(context);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_prepare_view, (ViewGroup)this, true);
        this.mThumb = (ImageView)this.findViewById(R.id.thumb);
        this.mStartPlay = (ImageView)this.findViewById(R.id.start_play);
        this.mLoading = (ProgressBar)this.findViewById(R.id.loading);
        this.mNetWarning = (FrameLayout)this.findViewById(R.id.net_warning_layout);
        this.findViewById(R.id.status_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PrepareView.this.mNetWarning.setVisibility(8);
                VideoViewManager.instance().setPlayOnMobileNetwork(true);
                PrepareView.this.mControlWrapper.start();
            }
        });
    }

    public PrepareView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_prepare_view, (ViewGroup)this, true);
        this.mThumb = (ImageView)this.findViewById(R.id.thumb);
        this.mStartPlay = (ImageView)this.findViewById(R.id.start_play);
        this.mLoading = (ProgressBar)this.findViewById(R.id.loading);
        this.mNetWarning = (FrameLayout)this.findViewById(R.id.net_warning_layout);
        this.findViewById(R.id.status_btn).setOnClickListener(new /* invalid duplicate definition of identical inner class */);
    }

    public PrepareView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dkplayer_layout_prepare_view, (ViewGroup)this, true);
        this.mThumb = (ImageView)this.findViewById(R.id.thumb);
        this.mStartPlay = (ImageView)this.findViewById(R.id.start_play);
        this.mLoading = (ProgressBar)this.findViewById(R.id.loading);
        this.mNetWarning = (FrameLayout)this.findViewById(R.id.net_warning_layout);
        this.findViewById(R.id.status_btn).setOnClickListener(new /* invalid duplicate definition of identical inner class */);
    }

    public void setClickStart() {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PrepareView.this.mControlWrapper.start();
            }
        });
    }

    public void attach(@NonNull ControlWrapper controlWrapper) {
        this.mControlWrapper = controlWrapper;
    }

    public View getView() {
        return this;
    }

    public void onVisibilityChanged(boolean isVisible, Animation anim) {
    }

    public void onPlayStateChanged(int playState) {
        switch (playState) {
            case 1: {
                this.bringToFront();
                this.setVisibility(0);
                this.mStartPlay.setVisibility(8);
                this.mNetWarning.setVisibility(8);
                this.mLoading.setVisibility(0);
                break;
            }
            case -1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.setVisibility(8);
                break;
            }
            case 0: {
                this.setVisibility(0);
                this.bringToFront();
                this.mLoading.setVisibility(8);
                this.mNetWarning.setVisibility(8);
                this.mStartPlay.setVisibility(0);
                this.mThumb.setVisibility(0);
                break;
            }
            case 8: {
                this.setVisibility(0);
                this.mNetWarning.setVisibility(0);
                this.mNetWarning.bringToFront();
            }
        }
    }

    public void onPlayerStateChanged(int playerState) {
    }

    public void setProgress(int duration, int position) {
    }

    public void onLockStateChanged(boolean isLocked) {
    }
}

