/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videoplayer.player;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import xyz.doikki.videoplayer.R;
import xyz.doikki.videoplayer.controller.BaseVideoController;
import xyz.doikki.videoplayer.controller.MediaPlayerControl;
import xyz.doikki.videoplayer.player.AbstractPlayer;
import xyz.doikki.videoplayer.player.AudioFocusHelper;
import xyz.doikki.videoplayer.player.PlayerFactory;
import xyz.doikki.videoplayer.player.ProgressManager;
import xyz.doikki.videoplayer.player.VideoViewConfig;
import xyz.doikki.videoplayer.player.VideoViewManager;
import xyz.doikki.videoplayer.render.IRenderView;
import xyz.doikki.videoplayer.render.RenderViewFactory;
import xyz.doikki.videoplayer.util.L;
import xyz.doikki.videoplayer.util.PlayerUtils;

public class VideoView<P extends AbstractPlayer>
extends FrameLayout
implements MediaPlayerControl,
AbstractPlayer.PlayerEventListener {
    protected P mMediaPlayer;
    protected PlayerFactory<P> mPlayerFactory;
    @Nullable
    protected BaseVideoController mVideoController;
    protected FrameLayout mPlayerContainer;
    protected IRenderView mRenderView;
    protected RenderViewFactory mRenderViewFactory;
    public static final int SCREEN_SCALE_DEFAULT = 0;
    public static final int SCREEN_SCALE_16_9 = 1;
    public static final int SCREEN_SCALE_4_3 = 2;
    public static final int SCREEN_SCALE_MATCH_PARENT = 3;
    public static final int SCREEN_SCALE_ORIGINAL = 4;
    public static final int SCREEN_SCALE_CENTER_CROP = 5;
    protected int mCurrentScreenScaleType;
    protected int[] mVideoSize = new int[]{0, 0};
    protected boolean mIsMute;
    protected String mUrl;
    protected Map<String, String> mHeaders;
    protected AssetFileDescriptor mAssetFileDescriptor;
    protected long mCurrentPosition;
    public static final int STATE_ERROR = -1;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_PREPARED = 2;
    public static final int STATE_PLAYING = 3;
    public static final int STATE_PAUSED = 4;
    public static final int STATE_PLAYBACK_COMPLETED = 5;
    public static final int STATE_BUFFERING = 6;
    public static final int STATE_BUFFERED = 7;
    public static final int STATE_START_ABORT = 8;
    protected int mCurrentPlayState = 0;
    public static final int PLAYER_NORMAL = 10;
    public static final int PLAYER_FULL_SCREEN = 11;
    public static final int PLAYER_TINY_SCREEN = 12;
    protected int mCurrentPlayerState = 10;
    protected boolean mIsFullScreen;
    protected boolean mIsTinyScreen;
    protected int[] mTinyScreenSize = new int[]{0, 0};
    protected boolean mEnableAudioFocus;
    @Nullable
    protected AudioFocusHelper mAudioFocusHelper;
    protected List<OnStateChangeListener> mOnStateChangeListeners;
    @Nullable
    protected ProgressManager mProgressManager;
    protected boolean mIsLooping;
    private int mPlayerBackgroundColor;

    public VideoView(@NonNull Context context) {
        this(context, null);
    }

    public VideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VideoView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        VideoViewConfig config = VideoViewManager.getConfig();
        this.mEnableAudioFocus = config.mEnableAudioFocus;
        this.mProgressManager = config.mProgressManager;
        this.mPlayerFactory = config.mPlayerFactory;
        this.mCurrentScreenScaleType = config.mScreenScaleType;
        this.mRenderViewFactory = config.mRenderViewFactory;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VideoView);
        this.mEnableAudioFocus = a.getBoolean(R.styleable.VideoView_enableAudioFocus, this.mEnableAudioFocus);
        this.mIsLooping = a.getBoolean(R.styleable.VideoView_looping, false);
        this.mCurrentScreenScaleType = a.getInt(R.styleable.VideoView_screenScaleType, this.mCurrentScreenScaleType);
        this.mPlayerBackgroundColor = a.getColor(R.styleable.VideoView_playerBackgroundColor, -16777216);
        a.recycle();
        this.initView();
    }

    protected void initView() {
        this.mPlayerContainer = new FrameLayout(this.getContext());
        this.mPlayerContainer.setBackgroundColor(this.mPlayerBackgroundColor);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mPlayerContainer, (ViewGroup.LayoutParams)params);
    }

    public void setPlayerBackgroundColor(int color) {
        this.mPlayerContainer.setBackgroundColor(color);
    }

    @Override
    public void start() {
        if (this.isInIdleState() || this.isInStartAbortState()) {
            this.startPlay();
        } else if (this.isInPlaybackState()) {
            this.startInPlaybackState();
        }
    }

    protected boolean startPlay() {
        if (this.showNetWarning()) {
            this.setPlayState(8);
            return false;
        }
        if (this.mEnableAudioFocus) {
            this.mAudioFocusHelper = new AudioFocusHelper(this);
        }
        if (this.mProgressManager != null) {
            this.mCurrentPosition = this.mProgressManager.getSavedProgress(this.mUrl);
        }
        this.initPlayer();
        this.addDisplay();
        this.startPrepare(false);
        return true;
    }

    protected boolean showNetWarning() {
        if (this.isLocalDataSource()) {
            return false;
        }
        return this.mVideoController != null && this.mVideoController.showNetWarning();
    }

    protected boolean isLocalDataSource() {
        if (this.mAssetFileDescriptor != null) {
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
            Uri uri = Uri.parse((String)this.mUrl);
            return "android.resource".equals(uri.getScheme()) || "file".equals(uri.getScheme()) || "rawresource".equals(uri.getScheme());
        }
        return false;
    }

    protected void initPlayer() {
        this.mMediaPlayer = this.mPlayerFactory.createPlayer(this.getContext());
        ((AbstractPlayer)this.mMediaPlayer).setPlayerEventListener(this);
        this.setInitOptions();
        ((AbstractPlayer)this.mMediaPlayer).initPlayer();
        this.setOptions();
    }

    protected void setInitOptions() {
    }

    protected void setOptions() {
        ((AbstractPlayer)this.mMediaPlayer).setLooping(this.mIsLooping);
        float volume = this.mIsMute ? 0.0f : 1.0f;
        ((AbstractPlayer)this.mMediaPlayer).setVolume(volume, volume);
    }

    protected void addDisplay() {
        if (this.mRenderView != null) {
            this.mPlayerContainer.removeView(this.mRenderView.getView());
            this.mRenderView.release();
        }
        this.mRenderView = this.mRenderViewFactory.createRenderView(this.getContext());
        this.mRenderView.attachToPlayer((AbstractPlayer)this.mMediaPlayer);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
        this.mPlayerContainer.addView(this.mRenderView.getView(), 0, (ViewGroup.LayoutParams)params);
    }

    protected void startPrepare(boolean reset) {
        if (reset) {
            ((AbstractPlayer)this.mMediaPlayer).reset();
            this.setOptions();
        }
        if (this.prepareDataSource()) {
            ((AbstractPlayer)this.mMediaPlayer).prepareAsync();
            this.setPlayState(1);
            this.setPlayerState(this.isFullScreen() ? 11 : (this.isTinyScreen() ? 12 : 10));
        }
    }

    protected boolean prepareDataSource() {
        if (this.mAssetFileDescriptor != null) {
            ((AbstractPlayer)this.mMediaPlayer).setDataSource(this.mAssetFileDescriptor);
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
            ((AbstractPlayer)this.mMediaPlayer).setDataSource(this.mUrl, this.mHeaders);
            return true;
        }
        return false;
    }

    protected void startInPlaybackState() {
        ((AbstractPlayer)this.mMediaPlayer).start();
        this.setPlayState(3);
        if (this.mAudioFocusHelper != null && !this.isMute()) {
            this.mAudioFocusHelper.requestFocus();
        }
        this.mPlayerContainer.setKeepScreenOn(true);
    }

    @Override
    public void pause() {
        if (this.isInPlaybackState() && ((AbstractPlayer)this.mMediaPlayer).isPlaying()) {
            ((AbstractPlayer)this.mMediaPlayer).pause();
            this.setPlayState(4);
            if (this.mAudioFocusHelper != null && !this.isMute()) {
                this.mAudioFocusHelper.abandonFocus();
            }
            this.mPlayerContainer.setKeepScreenOn(false);
        }
    }

    public void resume() {
        if (this.isInPlaybackState() && !((AbstractPlayer)this.mMediaPlayer).isPlaying()) {
            ((AbstractPlayer)this.mMediaPlayer).start();
            this.setPlayState(3);
            if (this.mAudioFocusHelper != null && !this.isMute()) {
                this.mAudioFocusHelper.requestFocus();
            }
            this.mPlayerContainer.setKeepScreenOn(true);
        }
    }

    public void release() {
        if (!this.isInIdleState()) {
            if (this.mMediaPlayer != null) {
                ((AbstractPlayer)this.mMediaPlayer).release();
                this.mMediaPlayer = null;
            }
            if (this.mRenderView != null) {
                this.mPlayerContainer.removeView(this.mRenderView.getView());
                this.mRenderView.release();
                this.mRenderView = null;
            }
            if (this.mAssetFileDescriptor != null) {
                try {
                    this.mAssetFileDescriptor.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.mAudioFocusHelper != null) {
                this.mAudioFocusHelper.abandonFocus();
                this.mAudioFocusHelper = null;
            }
            this.mPlayerContainer.setKeepScreenOn(false);
            this.saveProgress();
            this.mCurrentPosition = 0L;
            this.setPlayState(0);
        }
    }

    protected void saveProgress() {
        if (this.mProgressManager != null && this.mCurrentPosition > 0L) {
            L.d("saveProgress: " + this.mCurrentPosition);
            this.mProgressManager.saveProgress(this.mUrl, this.mCurrentPosition);
        }
    }

    protected boolean isInPlaybackState() {
        return this.mMediaPlayer != null && this.mCurrentPlayState != -1 && this.mCurrentPlayState != 0 && this.mCurrentPlayState != 1 && this.mCurrentPlayState != 8 && this.mCurrentPlayState != 5;
    }

    protected boolean isInIdleState() {
        return this.mCurrentPlayState == 0;
    }

    private boolean isInStartAbortState() {
        return this.mCurrentPlayState == 8;
    }

    @Override
    public void replay(boolean resetPosition) {
        if (resetPosition) {
            this.mCurrentPosition = 0L;
        }
        this.addDisplay();
        this.startPrepare(true);
    }

    @Override
    public long getDuration() {
        if (this.isInPlaybackState()) {
            return ((AbstractPlayer)this.mMediaPlayer).getDuration();
        }
        return 0L;
    }

    @Override
    public long getCurrentPosition() {
        if (this.isInPlaybackState()) {
            this.mCurrentPosition = ((AbstractPlayer)this.mMediaPlayer).getCurrentPosition();
            return this.mCurrentPosition;
        }
        return 0L;
    }

    @Override
    public void seekTo(long pos) {
        if (this.isInPlaybackState()) {
            ((AbstractPlayer)this.mMediaPlayer).seekTo(pos);
        }
    }

    @Override
    public boolean isPlaying() {
        return this.isInPlaybackState() && ((AbstractPlayer)this.mMediaPlayer).isPlaying();
    }

    @Override
    public int getBufferedPercentage() {
        return this.mMediaPlayer != null ? ((AbstractPlayer)this.mMediaPlayer).getBufferedPercentage() : 0;
    }

    @Override
    public void setMute(boolean isMute) {
        this.mIsMute = isMute;
        if (this.mMediaPlayer != null) {
            float volume = isMute ? 0.0f : 1.0f;
            ((AbstractPlayer)this.mMediaPlayer).setVolume(volume, volume);
        }
    }

    @Override
    public boolean isMute() {
        return this.mIsMute;
    }

    @Override
    public void onPrepared() {
        this.setPlayState(2);
        if (!this.isMute() && this.mAudioFocusHelper != null) {
            this.mAudioFocusHelper.requestFocus();
        }
        if (this.mCurrentPosition > 0L) {
            this.seekTo(this.mCurrentPosition);
        }
    }

    @Override
    public void onInfo(int what, int extra) {
        switch (what) {
            case 701: {
                this.setPlayState(6);
                break;
            }
            case 702: {
                this.setPlayState(7);
                break;
            }
            case 3: {
                this.setPlayState(3);
                this.mPlayerContainer.setKeepScreenOn(true);
                break;
            }
            case 10001: {
                if (this.mRenderView == null) break;
                this.mRenderView.setVideoRotation(extra);
            }
        }
    }

    @Override
    public void onError() {
        this.mPlayerContainer.setKeepScreenOn(false);
        this.setPlayState(-1);
    }

    @Override
    public void onCompletion() {
        this.mPlayerContainer.setKeepScreenOn(false);
        this.mCurrentPosition = 0L;
        if (this.mProgressManager != null) {
            this.mProgressManager.saveProgress(this.mUrl, 0L);
        }
        this.setPlayState(5);
    }

    public int getCurrentPlayerState() {
        return this.mCurrentPlayerState;
    }

    public int getCurrentPlayState() {
        return this.mCurrentPlayState;
    }

    @Override
    public long getTcpSpeed() {
        return this.mMediaPlayer != null ? ((AbstractPlayer)this.mMediaPlayer).getTcpSpeed() : 0L;
    }

    @Override
    public void setSpeed(float speed) {
        if (this.isInPlaybackState()) {
            ((AbstractPlayer)this.mMediaPlayer).setSpeed(speed);
        }
    }

    @Override
    public float getSpeed() {
        if (this.isInPlaybackState()) {
            return ((AbstractPlayer)this.mMediaPlayer).getSpeed();
        }
        return 1.0f;
    }

    public void setUrl(String url) {
        this.setUrl(url, null);
    }

    public void setUrl(String url, Map<String, String> headers) {
        this.mAssetFileDescriptor = null;
        this.mUrl = url;
        this.mHeaders = headers;
    }

    public void setAssetFileDescriptor(AssetFileDescriptor fd) {
        this.mUrl = null;
        this.mAssetFileDescriptor = fd;
    }

    public void skipPositionWhenPlay(int position) {
        this.mCurrentPosition = position;
    }

    public void setVolume(float v1, float v2) {
        if (this.mMediaPlayer != null) {
            ((AbstractPlayer)this.mMediaPlayer).setVolume(v1, v2);
        }
    }

    public void setProgressManager(@Nullable ProgressManager progressManager) {
        this.mProgressManager = progressManager;
    }

    public void setLooping(boolean looping) {
        this.mIsLooping = looping;
        if (this.mMediaPlayer != null) {
            ((AbstractPlayer)this.mMediaPlayer).setLooping(looping);
        }
    }

    public void setEnableAudioFocus(boolean enableAudioFocus) {
        this.mEnableAudioFocus = enableAudioFocus;
    }

    public void setPlayerFactory(PlayerFactory<P> playerFactory) {
        if (playerFactory == null) {
            throw new IllegalArgumentException("PlayerFactory can not be null!");
        }
        this.mPlayerFactory = playerFactory;
    }

    public void setRenderViewFactory(RenderViewFactory renderViewFactory) {
        if (renderViewFactory == null) {
            throw new IllegalArgumentException("RenderViewFactory can not be null!");
        }
        this.mRenderViewFactory = renderViewFactory;
    }

    @Override
    public void startFullScreen() {
        if (this.mIsFullScreen) {
            return;
        }
        ViewGroup decorView = this.getDecorView();
        if (decorView == null) {
            return;
        }
        this.mIsFullScreen = true;
        this.hideSysBar(decorView);
        this.removeView((View)this.mPlayerContainer);
        decorView.addView((View)this.mPlayerContainer);
        this.setPlayerState(11);
    }

    private void hideSysBar(ViewGroup decorView) {
        int uiOptions = decorView.getSystemUiVisibility();
        if (Build.VERSION.SDK_INT >= 16) {
            uiOptions |= 2;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            uiOptions |= 0x1000;
        }
        decorView.setSystemUiVisibility(uiOptions);
        this.getActivity().getWindow().setFlags(1024, 1024);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus && this.mIsFullScreen) {
            this.hideSysBar(this.getDecorView());
        }
    }

    @Override
    public void stopFullScreen() {
        if (!this.mIsFullScreen) {
            return;
        }
        ViewGroup decorView = this.getDecorView();
        if (decorView == null) {
            return;
        }
        this.mIsFullScreen = false;
        this.showSysBar(decorView);
        decorView.removeView((View)this.mPlayerContainer);
        this.addView((View)this.mPlayerContainer);
        this.setPlayerState(10);
    }

    private void showSysBar(ViewGroup decorView) {
        int uiOptions = decorView.getSystemUiVisibility();
        if (Build.VERSION.SDK_INT >= 16) {
            uiOptions &= 0xFFFFFFFD;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            uiOptions &= 0xFFFFEFFF;
        }
        decorView.setSystemUiVisibility(uiOptions);
        this.getActivity().getWindow().clearFlags(1024);
    }

    protected ViewGroup getDecorView() {
        Activity activity = this.getActivity();
        if (activity == null) {
            return null;
        }
        return (ViewGroup)activity.getWindow().getDecorView();
    }

    protected ViewGroup getContentView() {
        Activity activity = this.getActivity();
        if (activity == null) {
            return null;
        }
        return (ViewGroup)activity.findViewById(0x1020002);
    }

    protected Activity getActivity() {
        Activity activity;
        if (this.mVideoController != null) {
            activity = PlayerUtils.scanForActivity(this.mVideoController.getContext());
            if (activity == null) {
                activity = PlayerUtils.scanForActivity(this.getContext());
            }
        } else {
            activity = PlayerUtils.scanForActivity(this.getContext());
        }
        return activity;
    }

    @Override
    public boolean isFullScreen() {
        return this.mIsFullScreen;
    }

    @Override
    public void startTinyScreen() {
        int height;
        if (this.mIsTinyScreen) {
            return;
        }
        ViewGroup contentView = this.getContentView();
        if (contentView == null) {
            return;
        }
        this.removeView((View)this.mPlayerContainer);
        int width = this.mTinyScreenSize[0];
        if (width <= 0) {
            width = PlayerUtils.getScreenWidth(this.getContext(), false) / 2;
        }
        if ((height = this.mTinyScreenSize[1]) <= 0) {
            height = width * 9 / 16;
        }
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(width, height);
        params.gravity = 0x800055;
        contentView.addView((View)this.mPlayerContainer, (ViewGroup.LayoutParams)params);
        this.mIsTinyScreen = true;
        this.setPlayerState(12);
    }

    @Override
    public void stopTinyScreen() {
        if (!this.mIsTinyScreen) {
            return;
        }
        ViewGroup contentView = this.getContentView();
        if (contentView == null) {
            return;
        }
        contentView.removeView((View)this.mPlayerContainer);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        this.addView((View)this.mPlayerContainer, (ViewGroup.LayoutParams)params);
        this.mIsTinyScreen = false;
        this.setPlayerState(10);
    }

    @Override
    public boolean isTinyScreen() {
        return this.mIsTinyScreen;
    }

    @Override
    public void onVideoSizeChanged(int videoWidth, int videoHeight) {
        this.mVideoSize[0] = videoWidth;
        this.mVideoSize[1] = videoHeight;
        if (this.mRenderView != null) {
            this.mRenderView.setScaleType(this.mCurrentScreenScaleType);
            this.mRenderView.setVideoSize(videoWidth, videoHeight);
        }
    }

    public void setVideoController(@Nullable BaseVideoController mediaController) {
        this.mPlayerContainer.removeView((View)this.mVideoController);
        this.mVideoController = mediaController;
        if (mediaController != null) {
            mediaController.setMediaPlayer(this);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            this.mPlayerContainer.addView((View)this.mVideoController, (ViewGroup.LayoutParams)params);
        }
    }

    @Override
    public void setScreenScaleType(int screenScaleType) {
        this.mCurrentScreenScaleType = screenScaleType;
        if (this.mRenderView != null) {
            this.mRenderView.setScaleType(screenScaleType);
        }
    }

    @Override
    public void setMirrorRotation(boolean enable) {
        if (this.mRenderView != null) {
            this.mRenderView.getView().setScaleX(enable ? -1.0f : 1.0f);
        }
    }

    @Override
    public Bitmap doScreenShot() {
        if (this.mRenderView != null) {
            return this.mRenderView.doScreenShot();
        }
        return null;
    }

    @Override
    public int[] getVideoSize() {
        return this.mVideoSize;
    }

    @Override
    public void setRotation(float rotation) {
        if (this.mRenderView != null) {
            this.mRenderView.setVideoRotation((int)rotation);
        }
    }

    public void setTinyScreenSize(int[] tinyScreenSize) {
        this.mTinyScreenSize = tinyScreenSize;
    }

    protected void setPlayState(int playState) {
        this.mCurrentPlayState = playState;
        if (this.mVideoController != null) {
            this.mVideoController.setPlayState(playState);
        }
        if (this.mOnStateChangeListeners != null) {
            for (OnStateChangeListener l : PlayerUtils.getSnapshot(this.mOnStateChangeListeners)) {
                if (l == null) continue;
                l.onPlayStateChanged(playState);
            }
        }
    }

    protected void setPlayerState(int playerState) {
        this.mCurrentPlayerState = playerState;
        if (this.mVideoController != null) {
            this.mVideoController.setPlayerState(playerState);
        }
        if (this.mOnStateChangeListeners != null) {
            for (OnStateChangeListener l : PlayerUtils.getSnapshot(this.mOnStateChangeListeners)) {
                if (l == null) continue;
                l.onPlayerStateChanged(playerState);
            }
        }
    }

    public void addOnStateChangeListener(@NonNull OnStateChangeListener listener) {
        if (this.mOnStateChangeListeners == null) {
            this.mOnStateChangeListeners = new ArrayList<OnStateChangeListener>();
        }
        this.mOnStateChangeListeners.add(listener);
    }

    public void removeOnStateChangeListener(@NonNull OnStateChangeListener listener) {
        if (this.mOnStateChangeListeners != null) {
            this.mOnStateChangeListeners.remove(listener);
        }
    }

    public void setOnStateChangeListener(@NonNull OnStateChangeListener listener) {
        if (this.mOnStateChangeListeners == null) {
            this.mOnStateChangeListeners = new ArrayList<OnStateChangeListener>();
        } else {
            this.mOnStateChangeListeners.clear();
        }
        this.mOnStateChangeListeners.add(listener);
    }

    public void clearOnStateChangeListeners() {
        if (this.mOnStateChangeListeners != null) {
            this.mOnStateChangeListeners.clear();
        }
    }

    public boolean onBackPressed() {
        return this.mVideoController != null && this.mVideoController.onBackPressed();
    }

    protected Parcelable onSaveInstanceState() {
        L.d("onSaveInstanceState: " + this.mCurrentPosition);
        this.saveProgress();
        return super.onSaveInstanceState();
    }

    public static class SimpleOnStateChangeListener
    implements OnStateChangeListener {
        @Override
        public void onPlayerStateChanged(int playerState) {
        }

        @Override
        public void onPlayStateChanged(int playState) {
        }
    }

    public static interface OnStateChangeListener {
        public void onPlayerStateChanged(int var1);

        public void onPlayStateChanged(int var1);
    }
}

