/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videoplayer.render;

import android.view.View;

public class MeasureHelper {
    private int mVideoWidth;
    private int mVideoHeight;
    private int mCurrentScreenScale;
    private int mVideoRotationDegree;

    public void setVideoRotation(int videoRotationDegree) {
        this.mVideoRotationDegree = videoRotationDegree;
    }

    public void setVideoSize(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    public void setScreenScale(int screenScale) {
        this.mCurrentScreenScale = screenScale;
    }

    public int[] doMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mVideoRotationDegree == 90 || this.mVideoRotationDegree == 270) {
            widthMeasureSpec += heightMeasureSpec;
            heightMeasureSpec = widthMeasureSpec - heightMeasureSpec;
            widthMeasureSpec -= heightMeasureSpec;
        }
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mVideoHeight == 0 || this.mVideoWidth == 0) {
            return new int[]{width, height};
        }
        switch (this.mCurrentScreenScale) {
            default: {
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                    break;
                }
                if (this.mVideoWidth * height <= width * this.mVideoHeight) break;
                height = width * this.mVideoHeight / this.mVideoWidth;
                break;
            }
            case 4: {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                break;
            }
            case 1: {
                if (height > width / 16 * 9) {
                    height = width / 16 * 9;
                    break;
                }
                width = height / 9 * 16;
                break;
            }
            case 2: {
                if (height > width / 4 * 3) {
                    height = width / 4 * 3;
                    break;
                }
                width = height / 3 * 4;
                break;
            }
            case 3: {
                width = widthMeasureSpec;
                height = heightMeasureSpec;
                break;
            }
            case 5: {
                if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                    break;
                }
                height = width * this.mVideoHeight / this.mVideoWidth;
            }
        }
        return new int[]{width, height};
    }
}

