/*
 * Decompiled with CFR 0.152.
 */
package xyz.doikki.videoplayer.player;

import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;
import xyz.doikki.videoplayer.player.VideoView;

final class AudioFocusHelper
implements AudioManager.OnAudioFocusChangeListener {
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private WeakReference<VideoView> mWeakVideoView;
    private AudioManager mAudioManager;
    private boolean mStartRequested = false;
    private boolean mPausedForLoss = false;
    private int mCurrentFocus = 0;

    AudioFocusHelper(@NonNull VideoView videoView) {
        this.mWeakVideoView = new WeakReference<VideoView>(videoView);
        this.mAudioManager = (AudioManager)videoView.getContext().getApplicationContext().getSystemService("audio");
    }

    public void onAudioFocusChange(final int focusChange) {
        if (this.mCurrentFocus == focusChange) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                AudioFocusHelper.this.handleAudioFocusChange(focusChange);
            }
        });
        this.mCurrentFocus = focusChange;
    }

    private void handleAudioFocusChange(int focusChange) {
        VideoView videoView = (VideoView)this.mWeakVideoView.get();
        if (videoView == null) {
            return;
        }
        switch (focusChange) {
            case 1: 
            case 2: {
                if (this.mStartRequested || this.mPausedForLoss) {
                    videoView.start();
                    this.mStartRequested = false;
                    this.mPausedForLoss = false;
                }
                if (videoView.isMute()) break;
                videoView.setVolume(1.0f, 1.0f);
                break;
            }
            case -2: 
            case -1: {
                if (!videoView.isPlaying()) break;
                this.mPausedForLoss = true;
                videoView.pause();
                break;
            }
            case -3: {
                if (!videoView.isPlaying() || videoView.isMute()) break;
                videoView.setVolume(0.1f, 0.1f);
            }
        }
    }

    void requestFocus() {
        if (this.mCurrentFocus == 1) {
            return;
        }
        if (this.mAudioManager == null) {
            return;
        }
        int status = this.mAudioManager.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)this, 3, 1);
        if (1 == status) {
            this.mCurrentFocus = 1;
            return;
        }
        this.mStartRequested = true;
    }

    void abandonFocus() {
        if (this.mAudioManager == null) {
            return;
        }
        this.mStartRequested = false;
        this.mAudioManager.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)this);
    }
}

