/*
 * Decompiled with CFR 0.152.
 */
package com.dueeeke.videoplayer.player;

import androidx.annotation.Nullable;
import com.dueeeke.videoplayer.player.AndroidMediaPlayerFactory;
import com.dueeeke.videoplayer.player.PlayerFactory;
import com.dueeeke.videoplayer.player.ProgressManager;
import com.dueeeke.videoplayer.render.RenderViewFactory;
import com.dueeeke.videoplayer.render.TextureRenderViewFactory;

public class VideoViewConfig {
    public final boolean mPlayOnMobileNetwork;
    public final boolean mEnableOrientation;
    public final boolean mEnableAudioFocus;
    public final boolean mIsEnableLog;
    public final ProgressManager mProgressManager;
    public final PlayerFactory mPlayerFactory;
    public final int mScreenScaleType;
    public final RenderViewFactory mRenderViewFactory;
    public final boolean mAdaptCutout;

    public static Builder newBuilder() {
        return new Builder();
    }

    private VideoViewConfig(Builder builder) {
        this.mIsEnableLog = builder.mIsEnableLog;
        this.mEnableOrientation = builder.mEnableOrientation;
        this.mPlayOnMobileNetwork = builder.mPlayOnMobileNetwork;
        this.mEnableAudioFocus = builder.mEnableAudioFocus;
        this.mProgressManager = builder.mProgressManager;
        this.mScreenScaleType = builder.mScreenScaleType;
        this.mPlayerFactory = builder.mPlayerFactory == null ? AndroidMediaPlayerFactory.create() : builder.mPlayerFactory;
        this.mRenderViewFactory = builder.mRenderViewFactory == null ? TextureRenderViewFactory.create() : builder.mRenderViewFactory;
        this.mAdaptCutout = builder.mAdaptCutout;
    }

    public static final class Builder {
        private boolean mIsEnableLog;
        private boolean mPlayOnMobileNetwork;
        private boolean mEnableOrientation;
        private boolean mEnableAudioFocus = true;
        private ProgressManager mProgressManager;
        private PlayerFactory mPlayerFactory;
        private int mScreenScaleType;
        private RenderViewFactory mRenderViewFactory;
        private boolean mAdaptCutout = true;

        public Builder setEnableOrientation(boolean enableOrientation) {
            this.mEnableOrientation = enableOrientation;
            return this;
        }

        public Builder setPlayOnMobileNetwork(boolean playOnMobileNetwork) {
            this.mPlayOnMobileNetwork = playOnMobileNetwork;
            return this;
        }

        public Builder setEnableAudioFocus(boolean enableAudioFocus) {
            this.mEnableAudioFocus = enableAudioFocus;
            return this;
        }

        public Builder setProgressManager(@Nullable ProgressManager progressManager) {
            this.mProgressManager = progressManager;
            return this;
        }

        public Builder setLogEnabled(boolean enableLog) {
            this.mIsEnableLog = enableLog;
            return this;
        }

        public Builder setPlayerFactory(PlayerFactory playerFactory) {
            this.mPlayerFactory = playerFactory;
            return this;
        }

        public Builder setScreenScaleType(int screenScaleType) {
            this.mScreenScaleType = screenScaleType;
            return this;
        }

        public Builder setRenderViewFactory(RenderViewFactory renderViewFactory) {
            this.mRenderViewFactory = renderViewFactory;
            return this;
        }

        public Builder setAdaptCutout(boolean adaptCutout) {
            this.mAdaptCutout = adaptCutout;
            return this;
        }

        public VideoViewConfig build() {
            return new VideoViewConfig(this);
        }
    }
}

