/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.quicksocket.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.MalformedJsonException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import xyz.deftu.quicksocket.client.QuickSocketClient;
import xyz.deftu.quicksocket.common.CloseCode;
import xyz.deftu.quicksocket.common.QuickSocketConstants;
import xyz.deftu.quicksocket.common.exceptions.KeyAlreadyBoundException;
import xyz.deftu.quicksocket.common.packets.PacketBase;
import xyz.deftu.quicksocket.common.utils.JsonKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B/\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\bB/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fJ\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u001e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0005J \u0010 \u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u00020\u00162\n\u0010&\u001a\u00060'j\u0002`(J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.J\u000e\u0010,\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u000e\u00100\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$J\u000e\u00101\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR/\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00062"}, d2={"Lxyz/deftu/quicksocket/client/QuickSocketClient;", "Lorg/java_websocket/client/WebSocketClient;", "uri", "", "encoded", "", "headers", "", "(Ljava/lang/String;ZLjava/util/Map;)V", "Ljava/net/URI;", "(Ljava/net/URI;ZLjava/util/Map;)V", "getEncoded", "()Z", "packets", "", "Ljava/lang/Class;", "Lxyz/deftu/quicksocket/common/packets/PacketBase;", "getPackets", "()Ljava/util/Map;", "packets$delegate", "Lkotlin/Lazy;", "addPacket", "", "identifier", "packet", "handleMessage", "message", "onClose", "code", "", "reason", "remote", "onConnectionClosed", "Lxyz/deftu/quicksocket/common/CloseCode;", "onConnectionOpened", "handshake", "Lorg/java_websocket/handshake/ServerHandshake;", "onError", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onErrorOccurred", "throwable", "", "onMessage", "bytes", "Ljava/nio/ByteBuffer;", "onMessageReceived", "onOpen", "sendPacket", "QuickSocket"})
public class QuickSocketClient
extends WebSocketClient {
    private final boolean encoded;
    @NotNull
    private final Lazy packets$delegate;

    @JvmOverloads
    public QuickSocketClient(@NotNull URI uri, boolean encoded, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        super(uri, headers);
        this.encoded = encoded;
        this.packets$delegate = LazyKt.lazy((Function0)packets.2.INSTANCE);
    }

    public /* synthetic */ QuickSocketClient(URI uRI, boolean bl, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(uRI, bl, (Map<String, String>)map);
    }

    public final boolean getEncoded() {
        return this.encoded;
    }

    private final Map<String, Class<? extends PacketBase>> getPackets() {
        Lazy lazy = this.packets$delegate;
        return (Map)lazy.getValue();
    }

    @JvmOverloads
    public QuickSocketClient(@NotNull String uri, boolean encoded, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        URI uRI = URI.create(uri);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(uri)");
        this(uRI, encoded, headers);
    }

    public /* synthetic */ QuickSocketClient(String string, boolean bl, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, bl, (Map<String, String>)map);
    }

    public final void onOpen(@NotNull ServerHandshake handshake) {
        Intrinsics.checkNotNullParameter((Object)handshake, (String)"handshake");
        this.onConnectionOpened(handshake);
    }

    public final void onClose(int code, @NotNull String reason, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.onConnectionClosed(CloseCode.Companion.from(code), reason, remote);
    }

    public final void onError(@NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.onErrorOccurred(ex);
    }

    public final void onMessage(@NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        String string = StandardCharsets.UTF_8.decode(bytes).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UTF_8.decode(bytes).toString()");
        String message = string;
        if (this.encoded) {
            this.handleMessage(message);
        } else {
            this.onMessage(message);
        }
        this.onMessageReceived(bytes);
    }

    public final void onMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.encoded) {
            this.handleMessage(message);
        } else {
            String string = message;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(message.toByteArray())");
            this.onMessage(byteBuffer);
        }
        this.onMessageReceived(message);
    }

    private final void handleMessage(String message) {
        Constructor<? extends PacketBase> constructor;
        if (!JsonKt.isJson(message)) {
            return;
        }
        JsonElement raw = JsonParser.parseString((String)message);
        if (!raw.isJsonObject()) {
            throw new MalformedJsonException(Intrinsics.stringPlus((String)"Expected JsonObject, received ", (Object)raw.getClass().getSimpleName()));
        }
        JsonObject parsed = raw.getAsJsonObject();
        if (!parsed.has("identifier")) {
            return;
        }
        String identifier = parsed.get("identifier").getAsString();
        if (!this.getPackets().containsKey(identifier)) {
            return;
        }
        Class<? extends PacketBase> clazz = this.getPackets().get(identifier);
        Intrinsics.checkNotNull(clazz);
        Class<? extends PacketBase> clz = clazz;
        try {
            constructor = clz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            constructor = null;
        }
        Constructor<? extends PacketBase> constructor2 = constructor;
        if (constructor2 == null) {
            return;
        }
        Constructor<? extends PacketBase> constructor3 = constructor2;
        PacketBase packet = constructor3.newInstance(new Object[0]);
        JsonObject jsonObject = parsed.getAsJsonObject("data");
        if (jsonObject == null) {
            jsonObject = null;
        }
        packet.onPacketReceived(jsonObject);
    }

    public final void addPacket(@NotNull String identifier, @NotNull Class<? extends PacketBase> packet) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        if (this.getPackets().containsKey(identifier)) {
            throw new KeyAlreadyBoundException();
        }
        this.getPackets().put(identifier, packet);
    }

    public final void sendPacket(@NotNull PacketBase packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        JsonObject data = new JsonObject();
        packet.onPacketSent(data);
        JsonObject json = packet.asJson();
        json.add("data", (JsonElement)data);
        String content = QuickSocketConstants.INSTANCE.getGSON().toJson((JsonElement)json);
        if (this.encoded) {
            this.send(StandardCharsets.UTF_8.encode(content));
        } else {
            this.send(content);
        }
    }

    public void onConnectionOpened(@NotNull ServerHandshake handshake) {
        Intrinsics.checkNotNullParameter((Object)handshake, (String)"handshake");
    }

    public void onConnectionClosed(@NotNull CloseCode code, @NotNull String reason, boolean remote) {
        Intrinsics.checkNotNullParameter((Object)((Object)code), (String)"code");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
    }

    public void onErrorOccurred(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
    }

    public void onMessageReceived(@NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
    }

    public void onMessageReceived(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    @JvmOverloads
    public QuickSocketClient(@NotNull URI uri, boolean encoded) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(uri, encoded, null, 4, null);
    }

    @JvmOverloads
    public QuickSocketClient(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(uri, false, null, 6, null);
    }

    @JvmOverloads
    public QuickSocketClient(@NotNull String uri, boolean encoded) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(uri, encoded, null, 4, null);
    }

    @JvmOverloads
    public QuickSocketClient(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(uri, false, null, 6, null);
    }
}

