/*
 * Decompiled with CFR 0.152.
 */
package xyz.deftu.fd;

import java.io.File;
import xyz.deftu.fd.Constants;
import xyz.deftu.fd.DownloadCallback;
import xyz.deftu.fd.FileDownloader;
import xyz.deftu.fd.FileDownloaderFactory;

class FileDownloaderFactoryImpl
implements FileDownloaderFactory {
    private DownloadCallback downloadCallback = Constants.downloadCallback;
    private boolean caches = true;
    private String userAgent;
    private int timeout = 30000;

    FileDownloaderFactoryImpl() {
    }

    @Override
    public FileDownloader create(File tempDir, File existingFile) {
        return FileDownloader.create(tempDir, existingFile).withDownloadCallback(this.downloadCallback).withCaches(this.caches).withUserAgent(this.userAgent).withTimeout(this.timeout);
    }

    @Override
    public FileDownloader create(File tempDir) {
        return FileDownloader.create(tempDir).withDownloadCallback(this.downloadCallback).withCaches(this.caches).withUserAgent(this.userAgent).withTimeout(this.timeout);
    }

    @Override
    public FileDownloaderFactory withDownloadCallback(DownloadCallback callback) {
        this.downloadCallback = callback;
        return this;
    }

    @Override
    public FileDownloaderFactory withCaches(boolean caches) {
        this.caches = caches;
        return this;
    }

    @Override
    public FileDownloaderFactory withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public FileDownloaderFactory withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

