/*
 * Decompiled with CFR 0.152.
 */
package xyz.danoz.recyclerviewfastscroller;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.SectionIndexer;
import xyz.danoz.recyclerviewfastscroller.FastScrollerTouchListener;
import xyz.danoz.recyclerviewfastscroller.R;
import xyz.danoz.recyclerviewfastscroller.RecyclerViewScroller;
import xyz.danoz.recyclerviewfastscroller.calculation.progress.TouchableScrollProgressCalculator;
import xyz.danoz.recyclerviewfastscroller.sectionindicator.SectionIndicator;

public abstract class AbsRecyclerViewFastScroller
extends FrameLayout
implements RecyclerViewScroller {
    private static final int[] STYLEABLE = R.styleable.AbsRecyclerViewFastScroller;
    protected final View mBar;
    protected final View mHandle;
    private RecyclerView mRecyclerView;
    private SectionIndicator mSectionIndicator;
    protected RecyclerView.OnScrollListener mOnScrollListener;

    public AbsRecyclerViewFastScroller(Context context) {
        this(context, null, 0);
    }

    public AbsRecyclerViewFastScroller(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsRecyclerViewFastScroller(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = this.getContext().getTheme().obtainStyledAttributes(attrs, STYLEABLE, 0, 0);
        try {
            int layoutResource = attributes.getResourceId(R.styleable.AbsRecyclerViewFastScroller_rfs_fast_scroller_layout, this.getLayoutResourceId());
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            inflater.inflate(layoutResource, (ViewGroup)this, true);
            this.mBar = this.findViewById(R.id.scroll_bar);
            this.mHandle = this.findViewById(R.id.scroll_handle);
            Drawable barDrawable = attributes.getDrawable(R.styleable.AbsRecyclerViewFastScroller_rfs_barBackground);
            int barColor = attributes.getColor(R.styleable.AbsRecyclerViewFastScroller_rfs_barColor, -7829368);
            this.applyCustomAttributesToView(this.mBar, barDrawable, barColor);
            Drawable handleDrawable = attributes.getDrawable(R.styleable.AbsRecyclerViewFastScroller_rfs_handleBackground);
            int handleColor = attributes.getColor(R.styleable.AbsRecyclerViewFastScroller_rfs_handleColor, -7829368);
            this.applyCustomAttributesToView(this.mHandle, handleDrawable, handleColor);
        }
        finally {
            attributes.recycle();
        }
        this.setOnTouchListener(new FastScrollerTouchListener(this));
    }

    private void applyCustomAttributesToView(View view, Drawable drawable, int color) {
        if (drawable != null) {
            this.setViewBackground(view, drawable);
        } else {
            view.setBackgroundColor(color);
        }
    }

    public void setHandleColor(int color) {
        this.mHandle.setBackgroundColor(color);
    }

    public void setHandleBackground(Drawable drawable) {
        this.setViewBackground(this.mHandle, drawable);
    }

    public void setBarColor(int color) {
        this.mBar.setBackgroundColor(color);
    }

    public void setBarBackground(Drawable drawable) {
        this.setViewBackground(this.mBar, drawable);
    }

    @TargetApi(value=16)
    private void setViewBackground(View view, Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(background);
        } else {
            view.setBackgroundDrawable(background);
        }
    }

    @Override
    public void setRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
    }

    public void setSectionIndicator(SectionIndicator sectionIndicator) {
        this.mSectionIndicator = sectionIndicator;
    }

    @Nullable
    public SectionIndicator getSectionIndicator() {
        return this.mSectionIndicator;
    }

    @Override
    public void scrollTo(float scrollProgress, boolean fromTouch) {
        int position = this.getPositionFromScrollProgress(scrollProgress);
        this.mRecyclerView.scrollToPosition(position);
        this.updateSectionIndicator(position, scrollProgress);
    }

    private void updateSectionIndicator(int position, float scrollProgress) {
        if (this.mSectionIndicator != null) {
            this.mSectionIndicator.setProgress(scrollProgress);
            if (this.mRecyclerView.getAdapter() instanceof SectionIndexer) {
                SectionIndexer indexer = (SectionIndexer)this.mRecyclerView.getAdapter();
                int section = indexer.getSectionForPosition(position);
                Object[] sections = indexer.getSections();
                this.mSectionIndicator.setSection(sections[section]);
            }
        }
    }

    private int getPositionFromScrollProgress(float scrollProgress) {
        return (int)((float)this.mRecyclerView.getAdapter().getItemCount() * scrollProgress);
    }

    @Override
    @NonNull
    public RecyclerView.OnScrollListener getOnScrollListener() {
        if (this.mOnScrollListener == null) {
            this.mOnScrollListener = new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    float scrollProgress = 0.0f;
                    TouchableScrollProgressCalculator scrollProgressCalculator = AbsRecyclerViewFastScroller.this.getScrollProgressCalculator();
                    if (scrollProgressCalculator != null) {
                        scrollProgress = scrollProgressCalculator.calculateScrollProgress(recyclerView);
                    }
                    AbsRecyclerViewFastScroller.this.moveHandleToPosition(scrollProgress);
                }
            };
        }
        return this.mOnScrollListener;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.getScrollProgressCalculator() == null) {
            this.onCreateScrollProgressCalculator();
        }
        float scrollProgress = this.getScrollProgressCalculator().calculateScrollProgress(this.mRecyclerView);
        this.moveHandleToPosition(scrollProgress);
    }

    protected abstract void onCreateScrollProgressCalculator();

    public float getScrollProgress(MotionEvent event) {
        TouchableScrollProgressCalculator scrollProgressCalculator = this.getScrollProgressCalculator();
        if (scrollProgressCalculator != null) {
            return this.getScrollProgressCalculator().calculateScrollProgress(event);
        }
        return 0.0f;
    }

    protected abstract int getLayoutResourceId();

    @Nullable
    protected abstract TouchableScrollProgressCalculator getScrollProgressCalculator();

    public abstract void moveHandleToPosition(float var1);
}

