/*
 * Decompiled with CFR 0.152.
 */
package xyz.danoz.recyclerviewfastscroller.sectionindicator.title;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import xyz.danoz.recyclerviewfastscroller.R;
import xyz.danoz.recyclerviewfastscroller.sectionindicator.AbsSectionIndicator;

public abstract class SectionTitleIndicator<T>
extends AbsSectionIndicator<T> {
    private static final int[] STYLEABLE = R.styleable.SectionTitleIndicator;
    private static final int DEFAULT_TITLE_INDICATOR_LAYOUT = R.layout.section_indicator_with_title;
    private static final int DEFAULT_BACKGROUND_COLOR = 0x1060000;
    private static final int DEFAULT_TEXT_COLOR = 17170443;
    private final View mIndicatorBackground = this.findViewById(R.id.section_title_popup);
    private final TextView mTitleText = (TextView)this.findViewById(R.id.section_indicator_text);

    public SectionTitleIndicator(Context context) {
        this(context, null);
    }

    public SectionTitleIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SectionTitleIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = this.getContext().getTheme().obtainStyledAttributes(attrs, STYLEABLE, 0, 0);
        try {
            int customBackgroundColor = attributes.getColor(R.styleable.SectionTitleIndicator_rfs_backgroundColor, this.getDefaultBackgroundColor());
            this.applyCustomBackgroundColorAttribute(customBackgroundColor);
            int customTextColor = attributes.getColor(R.styleable.SectionTitleIndicator_rfs_textColor, this.getDefaultBackgroundColor());
            this.applyCustomTextColorAttribute(customTextColor);
        }
        finally {
            attributes.recycle();
        }
    }

    @Override
    protected int getDefaultLayoutId() {
        return DEFAULT_TITLE_INDICATOR_LAYOUT;
    }

    @Override
    protected int getDefaultBackgroundColor() {
        return 0x1060000;
    }

    protected int getDefaultTextColor() {
        return 17170443;
    }

    @Override
    protected void applyCustomBackgroundColorAttribute(int color) {
        this.setIndicatorBackgroundColor(color);
    }

    public void setIndicatorBackgroundColor(int color) {
        Drawable backgroundDrawable = this.mIndicatorBackground.getBackground();
        if (backgroundDrawable instanceof GradientDrawable) {
            GradientDrawable backgroundShape = (GradientDrawable)backgroundDrawable;
            backgroundShape.setColor(color);
        } else {
            this.mIndicatorBackground.setBackgroundColor(color);
        }
    }

    protected void applyCustomTextColorAttribute(int color) {
        this.setIndicatorTextColor(color);
    }

    public void setIndicatorTextColor(int color) {
        this.mTitleText.setTextColor(color);
    }

    public void setTitleText(String text) {
        this.mTitleText.setText((CharSequence)text);
    }
}

