/*
 * Decompiled with CFR 0.152.
 */
package xyz.danoz.recyclerviewfastscroller.sectionindicator;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import xyz.danoz.recyclerviewfastscroller.R;
import xyz.danoz.recyclerviewfastscroller.calculation.VerticalScrollBoundsProvider;
import xyz.danoz.recyclerviewfastscroller.calculation.position.VerticalScreenPositionCalculator;
import xyz.danoz.recyclerviewfastscroller.sectionindicator.SectionIndicator;
import xyz.danoz.recyclerviewfastscroller.sectionindicator.animation.DefaultSectionIndicatorAlphaAnimator;

public abstract class AbsSectionIndicator<T>
extends FrameLayout
implements SectionIndicator<T> {
    private static final int[] STYLEABLE = R.styleable.AbsSectionIndicator;
    private VerticalScreenPositionCalculator mScreenPositionCalculator;
    private DefaultSectionIndicatorAlphaAnimator mDefaultSectionIndicatorAlphaAnimator;

    public AbsSectionIndicator(Context context) {
        this(context, null);
    }

    public AbsSectionIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsSectionIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = this.getContext().getTheme().obtainStyledAttributes(attrs, STYLEABLE, 0, 0);
        try {
            int layoutId = attributes.getResourceId(R.styleable.AbsSectionIndicator_section_indicator_layout, this.getDefaultLayoutId());
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            inflater.inflate(layoutId, (ViewGroup)this, true);
        }
        finally {
            attributes.recycle();
        }
        this.mDefaultSectionIndicatorAlphaAnimator = new DefaultSectionIndicatorAlphaAnimator((View)this);
    }

    protected abstract int getDefaultLayoutId();

    protected abstract int getDefaultBackgroundColor();

    protected abstract void applyCustomBackgroundColorAttribute(int var1);

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mScreenPositionCalculator == null) {
            VerticalScrollBoundsProvider boundsProvider = new VerticalScrollBoundsProvider(0.0f, ((ViewGroup)this.getParent()).getHeight() - this.getHeight());
            this.mScreenPositionCalculator = new VerticalScreenPositionCalculator(boundsProvider);
        }
    }

    @Override
    public void setProgress(float progress) {
        this.setY(this.mScreenPositionCalculator.getYPositionFromScrollProgress(progress));
    }

    @Override
    public void animateAlpha(float targetAlpha) {
        this.mDefaultSectionIndicatorAlphaAnimator.animateTo(targetAlpha);
    }

    @Override
    public abstract void setSection(T var1);
}

